% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionClassif.R
\name{autoplot.PredictionClassif}
\alias{autoplot.PredictionClassif}
\title{Plot for PredictionClassif}
\usage{
\method{autoplot}{PredictionClassif}(object, type = "stacked", ...)
}
\arguments{
\item{object}{(\link[mlr3:PredictionClassif]{mlr3::PredictionClassif}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{...}{(\code{any}):
Additional arguments, passed down to the respective \code{geom}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3:PredictionClassif]{mlr3::PredictionClassif}, depending on argument \code{type}:
\itemize{
\item \code{"stacked"} (default): Stacked barplot of true and estimated class labels.
\item \code{"roc"}: ROC curve (1 - specificity on x, sensitivity on y).
Requires package \CRANpkg{precrec}.
\item \code{"prc"}: Precision recall curve.
Requires package \CRANpkg{precrec}.
}
}
\examples{
library(mlr3)
library(mlr3viz)

task = tsk("spam")
learner = lrn("classif.rpart", predict_type = "prob")
object = learner$train(task)$predict(task)

head(fortify(object))
autoplot(object)
autoplot(object, type = "roc")
autoplot(object, type = "prc")
}
