% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClasssifRpart.R, R/LearnerRegrRpart.R
\name{autoplot.LearnerClassifRpart}
\alias{autoplot.LearnerClassifRpart}
\alias{autoplot.LearnerRegrRpart}
\title{Plot for LearnerClassifRpart}
\usage{
\method{autoplot}{LearnerClassifRpart}(object, ...)

\method{autoplot}{LearnerRegrRpart}(object, ...)
}
\arguments{
\item{object}{(\link[mlr3:mlr_learners_classif.rpart]{mlr3::LearnerClassifRpart} | \link[mlr3:mlr_learners_regr.rpart]{mlr3::LearnerRegrRpart}).}

\item{...}{(\code{any}):
Additional arguments, passed down to \code{\link[ggparty:autoplot.party]{ggparty::autoplot.party()}}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Visualize trees for \link[mlr3:mlr_learners_classif.rpart]{mlr3::mlr_learners_classif.rpart} or
\link[mlr3:mlr_learners_regr.rpart]{mlr3::mlr_learners_regr.rpart} using the package \CRANpkg{ggparty}.

Contrary to \CRANpkg{ggparty}, boxplots are shown in the terminal nodes for
regression trees.

Note that learner-specific plots are experimental and subject to change.
}
\examples{
library(mlr3)
library(mlr3viz)

task = tsk("spam")
learner = lrn("classif.rpart", keep_model = TRUE)
learner$train(task)
autoplot(learner)
}
