% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association_measures.R
\name{association}
\alias{association}
\alias{concordant}
\alias{discordant}
\alias{ties.row}
\alias{ties.col}
\alias{nom.phi}
\alias{nom.cc}
\alias{nom.TT}
\alias{nom.CV}
\alias{nom.lamba}
\alias{nom.uncertainty}
\alias{ord.gamma}
\alias{ord.tau}
\alias{ord.somers.d}
\alias{nom.lambda}
\alias{eta}
\title{Association measures}
\source{
From the \href{https://cran.r-project.org/package=ryouready}{archived \code{ryouready} package} by Mark Heckmann.
The code for the calculation of \code{nom.lambda}, \code{nom.uncertainty}, \code{ord.gamma}, \code{ord.tau}, \code{ord.somers.d}
was supplied by Marc Schwartz (under GPL 2) and checked against SPSS results.
}
\usage{
concordant(x, y = NULL)

discordant(x, y = NULL)

ties.row(x, y = NULL)

ties.col(x, y = NULL)

nom.phi(x, y = NULL)

nom.cc(x, y = NULL)

nom.TT(x, y = NULL)

nom.CV(x, y = NULL)

nom.lambda(x, y = NULL)

nom.uncertainty(x, y = NULL)

ord.gamma(x, y = NULL)

ord.tau(x, y = NULL)

ord.somers.d(x, y = NULL)

eta(x, y, breaks = NULL)
}
\arguments{
\item{x}{a numeric vector, table or matrix. \code{x} and \code{y} can also both be factors. \cr
For \code{eta} the independent nominal variable (factor or numeric).}

\item{y}{a numeric vector; ignored if \code{x} is a table or matrix.
If \code{x} is a factor, \code{y} should be a factor of the same length. \cr
For \code{eta} the dependent interval variable (numeric).}

\item{breaks}{either a numeric vector of two or more unique cut points or a single number (greater than or equal to 2)
giving the number of intervals into which \code{x} is to be cut (only for \code{eta}).}
}
\value{
the association coefficient(s)
}
\description{
Various association coefficients for nominal and ordinal data; the input formats follows \code{\link[stats:chisq.test]{stats::chisq.test()}}.
\itemize{
\item \code{concordant} concordant pairs
\item \code{discordant} discordant pairs
\item \code{ties.row} pairs tied on rows
\item \code{ties.col} pairs tied on columns
\item \code{nom.phi} Phi Coefficient
\item \code{nom.cc} Contingency Coefficient (Pearson's C) and Sakoda' s Adjusted Pearson's C
\item \code{nom.TT} Tshuprow's T (not meaningful for non-square tables)
\item \code{nom.CV} Cramer's V (for 2 x 2 tables V = Phi)
\item \code{nom.lambda} Goodman and Kruskal's Lambda with
\itemize{
\item{\code{lambda.cr}}{ The row variable is used as independent, the column variable as dependent variable.}
\item{\code{lambda.rc}}{ The column variable is used as independent, the row variable as dependent variable.}
\item{\code{lambda.symmetric}}{ Symmetric Lambda (the mean of both above).}
}
\item \code{nom.uncertainty} Uncertainty Coefficient (Theil's U) with
\itemize{
\item{\code{ucc.cr}}{ The row variable is used as independent, the column variable as dependent variable.}
\item{\code{uc.rc}}{ The column variable is used as independent, the row variable as dependent variable.}
\item{\code{uc.symmetric}}{ Symmetric uncertainty coefficient.}
}
\item \code{ord.gamma} Gamma coefficient
\item \code{ord.tau} a vector with Kendall-Stuart Tau's
\itemize{
\item{\code{tau.a}}{ Tau-a (for quadratic tables only)}
\item{\code{tau.b}}{ Tau-b}
\item{\code{tau.c}}{ Tau-c}
}
\item \code{ord.somers.d} Somers' d
\item \code{eta} Eta coefficient for nominal/interval data
}
}
\examples{
## Nominal data
# remove gender from the table
hec <- apply(HairEyeColor, 1:2, sum)
nom.phi(hec)
nom.cc(hec)
nom.TT(hec)
nom.CV(hec)
nom.lambda(hec)
nom.uncertainty(hec)
## Ordinal data
# create a fake data set
ordx <- sample(5, size=100, replace=TRUE)
ordy <- sample(5, size=100, replace=TRUE)
concordant(ordx, ordy)
discordant(ordx, ordy)
ties.row(ordx, ordy)
ties.col(ordx, ordy)
ord.gamma(ordx, ordy)
ord.tau(ordx, ordy)
ord.somers.d(ordx, ordy)
## Interval/nominal data
eta(iris$Species, iris$Sepal.Length)

}
