% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{HJG}
\alias{HJG}
\title{Henze-Jiménes-Gamero test statistic}
\usage{
HJG(data, a = 5)
}
\arguments{
\item{data}{a n x d numeric matrix of data values.}

\item{a}{positive numeric number (tuning parameter).}
}
\value{
The value of the test statistic.
}
\description{
Computes the test statistic of the Henze-Jimenes-Gamero test.
}
\details{
This functions evaluates the teststatistic with the given data and the specified tuning parameter \code{a}.
Each row of the data Matrix contains one of the n (multivariate) sample with dimension d. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the function returns an error.
}
\examples{
HJG(MASS::mvrnorm(50,c(0,1),diag(1,2)),a=5)

}
\references{
Henze, N., Jiménez-Gamero, M.D. (2019) "A new class of tests for multinormality with i.i.d. and garch data based on the empirical moment generating function", TEST, 28, 499-521, \href{https://doi.org/10.1007/s11749-018-0589-z}{DOI}
}
