% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_encoding.R
\name{set_encoding}
\alias{set_encoding}
\alias{get_encoding}
\title{Register Encoding Options for Model}
\usage{
set_encoding(model, mode, eng, options)

get_encoding(model)
}
\arguments{
\item{model}{A single character string for the model type (e.g.
\code{"k_means"}, etc).}

\item{mode}{A single character string for the model mode (e.g. "partition").}

\item{eng}{A single character string for the model engine.}

\item{options}{A list of options for engine-specific preprocessing encodings.
See Details below.}
}
\value{
A tibble
}
\description{
This function is used to register encoding information for a model, engine,
and mode combination.
}
\details{
The list passed to \code{options} needs the following values:
\itemize{
\item \strong{predictor_indicators} describes whether and how to create
indicator/dummy variables from factor predictors. There are three options:
\code{"none"} (do not expand factor predictors), \code{"traditional"} (apply the
standard \code{model.matrix()} encodings), and \code{"one_hot"} (create the complete
set including the baseline level for all factors).
\item \strong{compute_intercept} controls whether \code{model.matrix()} should include the
intercept in its formula. This affects more than the inclusion of an
intercept column. With an intercept, \code{model.matrix()} computes dummy
variables for all but one factor level. Without an intercept,
\code{model.matrix()} computes a full set of indicators for the first factor
variable, but an incomplete set for the remainder.
\item \strong{remove_intercept} removes the intercept column after \code{model.matrix()} is
finished. This can be useful if the model function (e.g. \code{lm()})
automatically generates an intercept.
\item \strong{allow_sparse_x} specifies whether the model can accommodate a sparse
representation for predictors during fitting and tuning.
}
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_new_model("shallow_learning_model")
set_model_mode("shallow_learning_model", "partition")
set_model_engine("shallow_learning_model", "partition", "stats")

set_encoding(
  model = "shallow_learning_model",
  mode = "partition",
  eng = "stats",
  options = list(
    predictor_indicators = "traditional",
    compute_intercept = TRUE,
    remove_intercept = TRUE,
    allow_sparse_x = FALSE
  )
)

get_encoding("shallow_learning_model")
get_encoding("shallow_learning_model")$value
\dontshow{\}) # examplesIf}
}
