% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_plugin.R
\name{bandwidth_plugin}
\alias{bandwidth_plugin}
\title{Plug-in bandwidth for local polynomial estimator of a psychometric function}
\usage{
bandwidth_plugin( r, m, x, link = "logit", guessing = 0,
                   lapsing = 0, K = 2, p = 1, ker = "dnorm" )
}
\arguments{
\item{r}{number of successes at points x}

\item{m}{number of trials at points x}

\item{x}{stimulus levels}

\item{link}{(optional) name of the link function to be used; default is "logit"}

\item{guessing}{(optional) guessing rate; default is 0}

\item{lapsing}{(optional) lapsing rate; default is 0}

\item{K}{(optional) power parameter for Weibull and reverse Weibull link; default is 2}

\item{p}{(optional) degree of the polynomial; default is 1}

\item{ker}{(optional) kernel function for weights; default is "dnorm"}
}
\value{
\verb{h  } plug-in bandwidth (ISE optimal on eta-scale)
}
\description{
The function calculates an estimate of the AMISE optimal bandwidth for
a local polynomial estimate of the psychometric function.
}
\examples{
data("Miranda_Henson")
x = Miranda_Henson$x
r = Miranda_Henson$r
m = Miranda_Henson$m
numxfit <- 199; # Number of new points to be generated minus 1
xfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
# Find a plug-in bandwidth
bwd <- bandwidth_plugin( r, m, x)
pfit <- locglmfit( xfit, r, m, x, bwd )$pfit
# Plot the fitted curve
plot( x, r / m, xlim = c( 0.1, 1.302 ), ylim = c( 0.0165, 0.965 ), type = "p", pch="*" )
lines(xfit, pfit )
}
