% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_balance.R
\name{datasummary_balance}
\alias{datasummary_balance}
\title{Balance table: Summary statistics for different subsets of the data (e.g.,
control and treatment groups)}
\usage{
datasummary_balance(
  formula,
  data,
  output = "default",
  fmt = 1,
  title = NULL,
  notes = NULL,
  align = NULL,
  add_columns = NULL,
  add_rows = NULL,
  dinm = TRUE,
  dinm_statistic = "std.error",
  ...
)
}
\arguments{
\item{formula}{a one-sided formula with the "condition" or "column" variable
on the right-hand side.}

\item{data}{A data.frame (or tibble). If this data includes columns called
"blocks", "clusters", and/or "weights", the 'estimatr' package will
consider them when calculating the difference in means.}

\item{output}{filename or object type (string)
\itemize{
  \item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
  \item Supported object types: "default", "html", "markdown", "latex", "data.frame", "gt", "kableExtra", "huxtable", "flextable".
  \item When a file name is supplied to the `output` argument, the table is written immediately to file. If you want to customize your table by post-processing it with functions provided by the `gt` or `kableExtra` packages, you need to choose a different output format (e.g., "gt", "latex", "html", "markdown"), and you need to save the table after post-processing using the `gt::gtsave`, `kableExtra::save_kable`, or `cat` functions.
}}

\item{fmt}{an integer, string, or function which determines how to format numeric values:
\itemize{
  \item integer: the number of digits to keep after the period (`format(round(x, fmt), nsmall=fmt)`)
  \item character: string is passed to the `sprintf` function. '\%.3f' will keep 3 digits after the decimal point with trailing zero. '\%.5f' will keep 5 digits. '\%.3e' will use exponential notation. See `?sprintf` for more options.
  \item function: a function which returns a formatted character string
}}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{align}{A character string of length equal to the number of columns in
the table.  "lcr" means that the first column will be left-aligned, the 2nd
column center-aligned, and the 3rd column right-aligned.}

\item{add_columns}{a data.frame (or tibble) with the same number of rows as
your main table.}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See examples.}

\item{dinm}{TRUE calculates a difference in means with uncertainty
estimates. This option is only available if the `estimatr` package is
installed. If `data` includes columns named "blocks", "clusters", or
"weights", this information will be taken into account automatically by
`estimatr::difference_in_means`.}

\item{dinm_statistic}{string: "std.error" or "p.value"}

\item{...}{all other arguments are passed to the `tidy` and `glance` methods
used to extract estimates from the model. For example, this allows users to
set `exponentiate=TRUE` to exponentiate logistic regression coefficients.}
}
\description{
Balance table: Summary statistics for different subsets of the data (e.g.,
control and treatment groups)
}
\examples{
\dontrun{
datasummary_balance(~am, mtcars)
}
}
\keyword{internal}
