% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_parallel_slopes.R
\name{gg_parallel_slopes}
\alias{gg_parallel_slopes}
\title{Plot parallel slopes model}
\usage{
gg_parallel_slopes(y, num_x, cat_x, data, alpha = 1)
}
\arguments{
\item{y}{Character string of outcome variable in \code{data}}

\item{num_x}{Character string of numerical explanatory/predictor variable in
\code{data}}

\item{cat_x}{Character string of categorical explanatory/predictor variable
in \code{data}}

\item{data}{an optional data frame, list or environment (or object
    coercible by \code{\link{as.data.frame}} to a data frame) containing
    the variables in the model.  If not found in \code{data}, the
    variables are taken from \code{environment(formula)},
    typically the environment from which \code{lm} is called.}

\item{alpha}{Transparency of points}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
NOTE: This function is deprecated; please use \code{\link{geom_parallel_slopes}}
instead. Output a visualization of linear regression when you have one numerical
and one categorical explanatory/predictor variable: a separate colored
regression line for each level of the categorical variable
}
\examples{
\dontrun{
library(ggplot2)
library(dplyr)
library(moderndive)

# log10() transformations
house_prices <- house_prices \%>\%
  mutate(
    log10_price = log10(price),
    log10_size = log10(sqft_living)
  )

# Output parallel slopes model plot:
gg_parallel_slopes(
  y = "log10_price", num_x = "log10_size", cat_x = "condition",
  data = house_prices, alpha = 0.1
) +
  labs(
    x = "log10 square feet living space", y = "log10 price in USD",
    title = "House prices in Seattle: Parallel slopes model"
  )

# Compare with interaction model plot:
ggplot(house_prices, aes(x = log10_size, y = log10_price, col = condition)) +
  geom_point(alpha = 0.1) +
  geom_smooth(method = "lm", se = FALSE, size = 1) +
  labs(
    x = "log10 square feet living space", y = "log10 price in USD",
    title = "House prices in Seattle: Interaction model"
  )
}
}
\seealso{
\code{\link{geom_parallel_slopes}}
}
