% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{TPB_UK}
\alias{TPB_UK}
\title{TPB_UK}
\source{
Gathered from a replication study by Hagger et al. (2023).

Obtained from \doi{10.23668/psycharchives.12187}
}
\description{
A dataset based on the Theory of Planned Behaviour from a
UK sample. 4 variables with high communality were selected for each
latent variable (ATT, SN, PBC, INT, BEH), from two time points (t1 and t2).
}
\examples{

tpb_uk <- "
# Outer Model (Based on Hagger et al., 2007)
 ATT =~ att3 + att2 + att1 + att4
 SN =~ sn4 + sn2 + sn3 + sn1
 PBC =~ pbc2 + pbc1 + pbc3 + pbc4
 INT =~ int2 + int1 + int3 + int4
 BEH =~ beh3 + beh2 + beh1 + beh4

# Inner Model (Based on Steinmetz et al., 2011)
 # Causal Relationsships
 INT ~ ATT + SN + PBC
 BEH ~ INT + PBC
 BEH ~ INT:PBC
"

est <- modsem(tpb_uk, data = TPB_UK)
summary(est)
}
