% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_paths_wright.R
\name{trace_path}
\alias{trace_path}
\title{Estimate formulas for (co-)variance paths using Wright's path tracing rules}
\usage{
trace_path(
  pt,
  x,
  y,
  parenthesis = TRUE,
  measurement.model = FALSE,
  maxlen = 100,
  ...
)
}
\arguments{
\item{pt}{A data frame with columns lhs, op, rhs, and mod, from modsemify(syntax)}

\item{x}{source variable}

\item{y}{destination variable}

\item{parenthesis}{if TRUE, the output will be enclosed in parenthesis}

\item{measurement.model}{if TRUE, the function will use the measurement model}

\item{maxlen}{maximum length of a path before aborting}

\item{...}{additional arguments passed to trace_path}
}
\value{
A string with the estimated path (simplified if possible)
}
\description{
This function estimates the path from x to y using the path tracing rules, 
note that it only works with structural parameters, so "=~" are ignored. unless 
measurement.model = TRUE.
you want to use the measurement model, 
"~" in the mod column of pt.
}
\examples{
library(modsem)
m1 <- '
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3

  # Inner model
  Y ~ X + Z + X:Z
'
pt <- modsemify(m1)
trace_path(pt, "Y", "Y") # variance of Y
}
