% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{generate_individual_graphs}
\alias{generate_individual_graphs}
\title{Builds graphs from specified network layers}
\usage{
generate_individual_graphs(layers, settings)
}
\arguments{
\item{layers}{Named list with different network layers containing data and identifiers for both
groups (generated from \code{\link{make_layer}})}

\item{settings}{A named list containing pipeline settings}
}
\value{
A nested named list with first-level elements `graphs` and `annotations`. The second
level elements are `group1` and `group2`. These contain a list of iGraph objects (`graphs`)
and data frames (`annotations`) mapping the graph node IDs to biological identifiers.
}
\description{
Constructs and returns two graphs for each network layer, where nodes
correspond to the rows in the measurement data.
Graphs are initially complete and edges are weighted by correlation of
measurements across columns. The number of edges is then reduced by either a
threshold on the p-value of the correlation or a minimum scale-free fit
index.
Each node is mapped to the biological
identifiers given in the layer and the mapping table is returned as
`annotations`.
}
\examples{
\dontshow{
WGCNA::disableWGCNAThreads()
}
data(layers_example)
layers <- layers_example
settings <- molnet::molnet_settings(handling_missing_data="pairwise.complete.obs")
individual_graphs <- molnet::generate_individual_graphs(layers, settings)
molnet::graph_metrics(individual_graphs$graphs$group1$mrna)
molnet::graph_metrics(individual_graphs$graphs$group2$mrna)

}
