% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stdLM.R
\name{stdLM}
\alias{stdLM}
\title{Standardization of landmark configuration by a reference landmark}
\usage{
stdLM(x, reflect = FALSE, swap = FALSE, sgn = c(1, 1))
}
\arguments{
\item{x}{an array containing landmark coordinate data of anchor from the specimens of interest}

\item{reflect}{if TRUE, x-coordinates are reflected around the x=0 axis}

\item{swap}{if TRUE, the x and y-coordinates are swapped}

\item{sgn}{a numeric vector; two choices 1 and -1; defaults to c(1,1)}
}
\value{
an array of landmark coordinates
}
\description{
This function provides options for reflecting GPA coordinates around x=0, swapping of GPA xy-coordinates,
and rotating all GPA coordinates in such a way that landmark 7 is standardized at x=0.
}
\details{
The values in the \code{sgn} vector should be tuned to obtain the desired orientation of landmark configuration.
This function processes the output from \code{procrustesFit}, which requires the \code{geomorph} package
(Version 3.0.0; Adams & Otarola-Castillo, 2013).
}
\examples{
library(geomorph)

data(ligophorus_tpsdata)
#A data processing step to parse out the orientation of landmarks
#from samples of L.parvicopulatrix

O <- matrix(0, length(ligophorus_tpsdata$parvicopulatrix), 4)
for(w in 1:length(ligophorus_tpsdata$parvicopulatrix)){
	result <- mapply(function(k)
	anglePolygon(matrix2list(ligophorus_tpsdata$parvicopulatrix[[w]][(11*(k-1)+1):(11*k),]),
	degree=TRUE), k=1:4)

	result_angle <- mapply(function(k) list(result[[2*k-1]]), k=1:4)
	result_orientation <- mapply(function(k) list(result[[2*k]]), k=1:4)
	names(result_angle) <- names(result_orientation) <- c("VR","VL","DR","DL")
	O[w,] <- unlist(result_orientation)
}

mdir <- apply(O, 2, function(k) which(k == "m") )
pdir <- apply(O, 2, function(k) which(k == "p") )

e <- 1 #Ventral right anchor
result <- procrustesFit(ligophorus_tpsdata$parvicopulatrix, e,
list(mdir[[e]], pdir[[e]]), PrinAxes=TRUE, showplot=TRUE)
#Standardize the x-coordinate of Landmark 7 by rotating the x-coordinate
#of its mean GPA xy-coordinate to x=0.
coordinates <- stdLM(result$coords, reflect=FALSE, swap=TRUE, sgn=c(1,-1))

plotLM(coordinates, "VR", pointscale=0.8,axispointscale=0.8,
meansize=1.2,polygon.outline=TRUE,c(-.6,.6),c(-.6,.6) )
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Adams DC, Otarola-Castillo E. (2013). geomorph: an R package for the collection and analysis of geometric morphometric shape data.
Methods in Ecology and Evolution 4:393-399.

Khang TF, Soo OYM, Tan WB, Lim LHS. (2016). Monogenean anchor morphometry: systematic value, phylogenetic signal, and evolution. PeerJ 4:e1668.
}
\seealso{
\code{\link{procrustesFit}}, \code{\link{plotLM}}
}

