% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapShape.R
\name{morphomapShape}
\alias{morphomapShape}
\title{morphomapShape}
\usage{
morphomapShape(
  morphomap.core,
  num.land,
  sects_vector,
  cent.out = "CCA",
  delta = 0.1,
  side = "left"
)
}
\arguments{
\item{morphomap.core}{list: morphomap.core object}

\item{num.land}{numeric: number of landmarks defining each section}

\item{sects_vector}{numeric: number of sections}

\item{cent.out}{how to define the center of each section. The method allowed are "CCA" (center of cortical area), "E" (barycenter of the external outline) and "I" (barycenter of the internal outline)}

\item{delta}{pixel size used to calculate the CCA}

\item{side}{character: specify if the long bone is "left" or "right" side}
}
\value{
3D_out num.pointsx3xnum.sect array in which the external outlines are stored

3D_inn num.pointsx3xnum.sect array in which the internal outlines are stored

2D_out num.pointsx2xnum.sect array in which the external outlines are stored

2D_inn num.pointsx2xnum.sect array in which the interal outlines are stored

ALPM_inn array with the coordinates of ALPM coordinates on the external outline

ALPM_out array with the coordinates of ALPM coordinates on the internal outline

mech_length mechanical length of the long bone

start percentage of the mechanical length from which the first section is defined

end percentage of the mechanical length from which the last section is defined
}
\description{
Tool for the extraction of equiangular landmarks on the entire diaphysis
}
\examples{
\donttest{
library(morphomap)
data(HomFem38023)
meshes<-morphomapSegm(HomFem38023, param1=4)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-380.23
rawSections<-morphomapCore(out.sur=perMesh, inn.sur=endMesh, num.sect=61 ,
mech.len = mech_length, start = 0.2,end=0.8,num.points = 500)
# Shape coordinates defining as center the barycenter of the cortical area
shapeSections_CCA<-morphomapShape(rawSections,21,sects_vector=NULL, cent.out="CCA",
delta=0.1,side="left")
# First the first cross section (2D)
morphomapPlotShape(shapeSections_CCA,dims=2,cent.out="CCA",vecs=1)
# First the first cross section (3D)
morphomapPlotShape(shapeSections_CCA,dims=3,size=0.5,lwd=2,cent.out="I",vecs=1)
# The entire diaphysis (3D)
morphomapPlotShape(shapeSections_CCA,dims=3,size=0.5,lwd=2,cent.out="I",vecs=NULL)
# Shape coordinates defining as center the barycenter of the external perimeter
shapeSections_E<-morphomapShape(rawSections, 21, sects_vector=NULL, cent.out="E", 
delta=0.1, side="left")
# First the first cross section (2D)
morphomapPlotShape(shapeSections_E,dims=2,cent.out="E",vecs=1)
# First the first cross section (3D)
morphomapPlotShape(shapeSections_E,dims=3,size=0.5,lwd=2,cent.out="I",vecs=1)
# The entire diaphysis (3D)
morphomapPlotShape(shapeSections_E,dims=3,size=0.5,lwd=2,cent.out="I",vecs=NULL)

# Shape coordinates defining as center the barycenter of the internal perimeter 
shapeSections_I<-morphomapShape(rawSections, 21, sects_vector=NULL, cent.out="I", 
delta=0.1, side="left")
# First the first cross section (2D)
morphomapPlotShape(shapeSections_I,dims=2,lines=TRUE,cent.out="I",vecs=1)
# First the first cross section (3D)
morphomapPlotShape(shapeSections_I,dims=3,lines=TRUE,centroid=TRUE, size=0.5,
lwd=2,cent.out="I",vecs=1)
# The entire diaphysis (3D)
morphomapPlotShape(shapeSections_I,dims=3,size=0.5,lwd=2,cent.out="I",vecs=NULL)
}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
