% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDoseResponse.survData.R
\name{plotDoseResponse.survData}
\alias{plotDoseResponse.survData}
\title{Plotting method for \code{survData} objects}
\usage{
\method{plotDoseResponse}{survData}(x, xlab = "Concentration",
  ylab = "Survival rate", main = NULL, target.time = NULL,
  style = "generic", log.scale = FALSE, remove.someLabels = FALSE,
  addlegend = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{survData}}

\item{xlab}{a title for the \eqn{x}-axis (optional)}

\item{ylab}{a label for the \eqn{y}-axis}

\item{main}{main title for the plot}

\item{target.time}{a numeric value corresponding to some observed time in \code{data}}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{log.scale}{if \code{TRUE}, displays \eqn{x}-axis in log scale}

\item{remove.someLabels}{if \code{TRUE}, removes 3/4 of X-axis labels in
\code{'ggplot'} style to avoid the label overlap}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{plotDoseResponse} S3 method for the \code{survData}
class. It plots the survival rate as a function of concentration (for a given
target time).
}
\details{
The function plots the observed values of the survival rate for a given time
as a function of concentration. The 95 \% binomial confidence interval is added
to each survival rate. It is calculated using function
\code{\link[stats]{binom.test}} from package \code{stats}.
Replicates are systematically pooled in this plot.
}
\note{
When \code{style = "ggplot"}, the function calls function
\code{\link[ggplot2]{ggplot}} and returns an object of class \code{ggplot}.
}
\examples{

library(ggplot2)

# (1) Load the data
data(zinc)
zinc <- survData(zinc)

# (2) Plot dose-response
plotDoseResponse(zinc)

# (3) Plot dose-response with a ggplot style
plotDoseResponse(zinc, style = "ggplot")

}
\seealso{
\code{\link[stats]{binom.test}}
}
\keyword{plot}

