% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.survFitPredict.R
\name{plot.survFitPredict}
\alias{plot.survFitPredict}
\title{Plotting method for \code{survFitPredict} objects}
\usage{
\method{plot}{survFitPredict}(x, xlab = "Time", ylab = "Survival rate",
  main = NULL, spaghetti = FALSE, one.plot = FALSE, adddata = FALSE,
  mcmc_size = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{survFitPredict}.}

\item{xlab}{A label for the \eqn{X}-axis, by default \code{Time}.}

\item{ylab}{A label for the \eqn{Y}-axis, by default \code{Survival rate}.}

\item{main}{A main title for the plot.}

\item{spaghetti}{If \code{TRUE}, draws a set of survival curves using
parameters drawn from the posterior distribution}

\item{one.plot}{if \code{TRUE}, draws all the estimated curves in
one plot instead of one plot per concentration.}

\item{adddata}{if \code{TRUE}, adds the observed data to the plot}

\item{mcmc_size}{A numerical value refering by default to the size of the mcmc in object \code{survFitPredict}.
This option is specific to \code{survFitPredict} objects for which computing time may be long.
\code{mcmc_size} can be used to reduce the number of mcmc samples in order to speed up
the computation.}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\description{
This is the generic \code{plot} S3 method for the
\code{survFitPredict}.  It plots the fit obtained for each
concentration of chemical compound in the provided dataset.
}
\details{
The fitted curves represent the \strong{estimated survival rate} as a function
of time for each concentration.
The black dots depict the \strong{observed survival
rate} at each time point.
The function plots both 95\% binomial credible intervals for the estimated survival
rate.
If \code{spaghetti = TRUE}, the credible intervals are represented by two
dotted lines limiting the credible band, and a spaghetti plot is added to this band.
This spaghetti plot consists of the representation of simulated curves using parameter values
sampled in the posterior distribution (10\% of the MCMC chains are randomly
taken for this sample).
}
\examples{

# (1) Load the survival data
data("propiconazole_pulse_exposure")

# (2) Create an object of class "survData"
dataset <- survData(propiconazole_pulse_exposure)

\dontrun{
# (3) Run the survFit function
out <- survFit(dataset , model_type = "SD")

# (4) Create a new data table for prediction
data_4prediction <- data.frame(time = 1:10, conc = c(0,5,5,5,0,0,5,5,5,5),
 replicate= rep("predict", 10))

# (5) Predict on a new dataset
predict_out <- predict(out, data_predict = data_4prediction, spaghetti = TRUE)

# (6) Plot the predicted curve
plot(predict_out)
plot(predict_out, spaghetti = TRUE)
}

}
\keyword{plot}
