% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pqrdata.R
\name{qdata_v}
\alias{qdata_v}
\alias{qdata_f}
\alias{cdata_v}
\alias{cdata_f}
\alias{pdata_v}
\alias{pdata_f}
\alias{rdata_v}
\alias{rdata_f}
\alias{ddata_v}
\alias{ddata_f}
\title{The Data Distribution}
\usage{
qdata_v(x, p = seq(0, 1, 0.25), na.rm = TRUE, ...)

qdata_f(x, ..., data = NULL, groups = NULL, na.rm = TRUE)

cdata_v(x, p = 0.95, na.rm = TRUE, ...)

cdata_f(x, ..., data = NULL, groups = NULL, na.rm = TRUE)

pdata_v(x, q, lower.tail = TRUE, ...)

pdata_f(x, ..., data = NULL, groups = NULL, na.rm = TRUE)

rdata_v(x, n, replace = TRUE, ...)

rdata_f(x, ..., data = NULL, groups = NULL, na.rm = TRUE)

ddata_v(x, q, ..., data = NULL, log = FALSE, na.rm = TRUE)

ddata_f(x, ..., data = NULL, groups = NULL, na.rm = TRUE)
}
\arguments{
\item{x}{a vector containing the data}

\item{p}{a vector of probabilities}

\item{na.rm}{a logical indicating whether \code{NA}s should be removed before computing.}

\item{\dots}{additional arguments passed to \code{quantile} or \code{sample}}

\item{data}{a data frame in which to evaluate \code{formula}}

\item{groups}{a grouping variable, typically the name of a variable in \code{data}}

\item{q}{a vector of quantiles}

\item{lower.tail}{a logical indicating whether to use the lower or upper tail probability}

\item{n}{number of values to sample}

\item{replace}{a logical indicating whether to sample with replacement}

\item{log}{a logical indicating whether the result should be log transformed}
}
\description{
Utility functions for density, distribution function, quantile function, 
and random generation from data.
}
\seealso{
\code{\link{ddata}}, \code{\link{pdata}}, \code{\link{qdata}},  
\code{\link{rdata}}, \code{\link{cdata}}
}
