% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{copy_tables_to_new_location}
\alias{copy_tables_to_new_location}
\title{Copy Tables to a New Database/Schema}
\usage{
copy_tables_to_new_location(
  .con,
  from_table_names,
  to_database_name,
  to_schema_name
)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{from_table_names}{A tibble/data frame listing source tables, with
columns \code{database_name}, \code{schema_name}, and \code{table_name}.}

\item{to_database_name}{Target database name.}

\item{to_schema_name}{Target schema name.}
}
\value{
Invisibly returns a character vector of fully-qualified destination table
names that were created. Side effect: creates target DB/schema if needed and
writes new tables.
}
\description{
Copies one or more tables to a new location (database/schema) by creating
new tables via \verb{CREATE TABLE ... AS SELECT * FROM ...}.
Requires motherduck connection
}
\details{
\itemize{
\item Input \code{from_table_names} must contain columns:
\code{database_name}, \code{schema_name}, and \code{table_name}.
\item For each source table, the function issues:
\verb{CREATE TABLE <to_db>.<to_schema>.<table> AS SELECT * FROM <src_db>.<src_schema>.<table>}.
\item On local DuckDB (non-MotherDuck), the target database name is ignored and
defaults to the current database of the connection.
}
}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
