% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{mt_space_normalize}
\alias{mt_space_normalize}
\title{Space normalize trajectories.}
\usage{
mt_space_normalize(data, use = "trajectories", save_as = "sn_trajectories",
  xpos_start = 0, xpos_end = NULL, ypos_start = 0, ypos_end = NULL,
  show_progress = TRUE)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import 
functions (see \link{mt_example} for details). Alternatively, a trajectory 
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be 
used.}

\item{save_as}{a character string specifying where the resulting trajectory 
data should be stored.}

\item{xpos_start}{an integer specifying the value the first x-position should
have in each trial.}

\item{xpos_end}{an integer specifying the value the last x-position should
have in each trial. If \code{NULL}, trajectories are only adjusted so that
they have the same start position.}

\item{ypos_start}{an integer specifying the value the first y-position should
have in each trial.}

\item{ypos_end}{an integer specifying the value the last y-position should
have in each trial. If  \code{NULL}, trajectories are only adjusted so that
they have the same start position.}

\item{show_progress}{logical indicating whether function should report on its
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}) with an additional
  array (by default called \code{sn_trajectories}) containing the 
  space-normalized trajectories. If a trajectory array was provided directly
  as \code{data}, only the space-normalized trajectories will be returned.
}
\description{
Adjust trajectories so that all trajectories have an identical start and end
point. If no end points are provided, trajectories are only adjusted so that
they have the same start position.
}
\examples{
mt_example <- mt_space_normalize(mt_example,
  save_as ="sn_trajectories",
  xpos_start=0, xpos_end=-1,
  ypos_start=0, ypos_end=1)

}
\references{
Dale, R., Kehoe, C., & Spivey, M. J. (2007). Graded motor
  responses in the time course of categorizing atypical exemplars.
  \emph{Memory & Cognition, 35}(1), 15-28.
}
\seealso{
\link{mt_align_start} for aligning the start position of
  trajectories.
  
  \link{mt_remap_symmetric} for remapping trajectories.
}

