% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_time.R
\name{mt_time}
\alias{mt_time}
\alias{mt_time<-}
\alias{mt_set_time}
\alias{mt_time_lags}
\title{Retrieve/replace timestamps or get the interval duration between locations}
\usage{
mt_time(x)

mt_time(x) <- value

mt_set_time(x, value)

mt_time_lags(x, units)
}
\arguments{
\item{x}{a \code{move2} object}

\item{value}{either a vector with new timestamps, the name of the new column to define time as a scalar character (this column must be present in the event table), or a scalar character to rename the time column.}

\item{units}{Optional. Valid values are \code{character}, \code{symbolic_units} or \code{units}, for more details see the \code{value} argument of \link[units:units]{units::as_units}. If no units are stated (default) the function flexibly determines the units to return. Fixing the units can be useful if specific return units are for example required for subsequent functions. This argument only takes effect if the initial return value already has units.}
}
\value{
\code{mt_time()} returns a vector of timestamps, depending on the type of data these can be either \code{POSIXct},
\code{date}or \code{numeric} \cr
\code{mt_time_lags()} returns a vector of the time lags as \code{numeric} or \code{\link[units]{units}} depending on the type of data.
}
\description{
\itemize{
\item \code{mt_time()} retrieve timestamps
\item \code{mt_time(x) <- value} and \code{mt_set_time(x, value)}  replace timestamps with new values, set new column to define time or rename time column
\item \code{mt_time_lags()} returns time lags, i.e. duration interval between consecutive locations
}
}
\details{
Time lags are calculated as the time difference to the next location.

When calculating time lags between locations \code{NA} values are used for the transitions between tracks. This is
because the interval between the last location of the previous track and first of the next track do not make
sense.
}
\examples{
## in the simulated track, time is numeric, so the time lags are also numeric
x <- mt_sim_brownian_motion(1:3)
x |> mt_time()
x |> mt_time_lags()

## here the simulated track has timestamps, so the time lags have units
x <- mt_sim_brownian_motion(as.POSIXct((1:3) * 60^2, origin = "1970-1-1"), tracks = 1)
x |> mt_time()
x |> mt_time_lags()
x <- mt_sim_brownian_motion(as.Date(1:3, "1990-1-1"), tracks = 2)
x |> mt_time()
x |> mt_time_lags()

## units of the time lags can also be transformed, e.g. from days to hours
tl <- x |> mt_time_lags()
units::set_units(tl, h)

x <- mt_sim_brownian_motion(t = as.POSIXct(1:3, , origin = "1970-1-1"), tracks = 2)
## providing a vector with new timestamps
head(mt_time(x))
mt_time(x) <- 1:nrow(x)
head(mt_time(x))

## renaming the column defining time
mt_time_column(x)
mt_time(x) <- "my_new_time_name"
mt_time_column(x)

## setting a new column to define time
x$new_time <- as.POSIXct(1:6, origin = "2020-1-1")
mt_time(x) <- "new_time"
mt_time_column(x)
head(mt_time(x))
}
\seealso{
Other track-measures: 
\code{\link{mt_azimuth}()},
\code{\link{mt_distance}()}
}
\concept{track-measures}
