\name{findqtl2}
\alias{findqtl2}
\title{Detect a second QTL in a QTL profile from (composite) interval mapping}
\usage{
  findqtl2(mpqtl, window, drop, dwindow = 5)
}
\arguments{
  \item{mpqtl}{Object of class \code{mpqtl}}

  \item{window}{cM on each side of initial QTL from which
  to exclude second peak}

  \item{drop}{Drop from original peak required in order to
  detect a second peak which is above the significance
  threshold}

  \item{dwindow}{Window over which to smooth p-values -
  default is five markers}
}
\value{
  The original input object with additional entries for
  newly detected QTL.
}
\description{
  Given the output from an initial scan of chromosomes with
  significant genetic variation, locates the second peak in
  a QTL profile.
}
\examples{
sim.map <- sim.map(len=rep(100, 2), n.mar=11, include.x=FALSE, eq.spacing=TRUE)
sim.ped <- sim.mpped(4, 1, 500, 6, 1)
sim.dat <- sim.mpcross(map=sim.map, pedigree=sim.ped, qtl=matrix(data=c(1, 10, .4, 0, 0, 0, 1, 70, 0, .35, 0, 0), nrow=2, ncol=6, byrow=TRUE), seed=1)
mpp.dat <- mpprob(sim.dat, program="qtl", step=2)
mpq.dat <- mpIM(object=mpp.dat, ncov=0, responsename="pheno")
mpq2 <- findqtl2(mpq.dat, drop=2)
plot(mpq2)
summary(mpq2)
}
\seealso{
  \code{\link[mpMap]{mpIM}},
  \code{\link[mpMap]{plot.mpqtl}},
  \code{\link[mpMap]{summary.mpqtl}}
}

