% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpp_perm.R
\name{mpp_perm}
\alias{mpp_perm}
\title{QTL significance threshold by permutation}
\usage{
mpp_perm(mppData, trait = 1, Q.eff = "cr", N = 1000, q.val = 0.95,
  verbose = TRUE, n.cores = 1)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{Q.eff}{\code{Character} expression indicating the assumption concerning
the QTL effects: 1) "cr" for cross-specific; 2) "par" for parental; 3) "anc"
for ancestral; 4) "biall" for a bi-allelic. For more details see
\code{\link{mpp_SIM}}. Default = "cr".}

\item{N}{Number of permutations. Default = 1000.}

\item{q.val}{Single \code{numeric} value or vector of desired quantiles from
the null distribution. Default = 0.95.}

\item{verbose}{\code{Logical} value indicating if progression of the function
should be printed. It will not affect the printing of the other functions
called by \code{mpp_perm()}, especially the printing of \code{asreml()}.
Default = TRUE.}

\item{n.cores}{\code{Numeric}. Specify here the number of cores you like to
use. Default = 1.}
}
\value{
Return:

\code{List} with the following object:

\item{max.pval }{Vector of the highest genome-wide -log10(p-values).}

\item{q.val }{Quantile values from the QTL significance threshold null
distribution.}

\item{seed}{\code{Numeric} vector of random generated seed values for each
permutation.}
}
\description{
Determination of an empirical null distribution of the QTL significance
threshold for a MPP QTL analysis using permutation test
(Churchill and Doerge, 1994).
}
\details{
Performs N permutations of the trait data and
computes each time a genome-wide QTL profile. For every run, it stores the
highest -log10(p-val). These values can be used to build a null distribution
for the QTL significance threshold. Quantile values can be determined from
the previous distribution. For more details about the different possible
models and their assumptions see \code{\link{mpp_SIM}} documentation.
}
\examples{

data(mppData)

Perm <- mpp_perm(mppData = mppData, Q.eff = "cr", N = 5)


}
\references{
Churchill, G. A., & Doerge, R. W. (1994). Empirical threshold values for
quantitative trait mapping. Genetics, 138(3), 963-971.
}
\seealso{
\code{\link{mpp_SIM}}
}
\author{
Vincent Garin
}
