% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{readBruker}
\alias{readBruker}
\title{A function for reading Bruker NMR spectra.}
\usage{
readBruker(
  folder = NULL,
  dimension = NULL,
  onlyTitles = FALSE,
  useAsNames = "Spectrum titles",
  checkFiles = FALSE
)
}
\arguments{
\item{folder}{Defines the exact NMR data folder. If NULL, mrbin parameter set is used}

\item{dimension}{Defines the data dimension, "1D" or "2D". Only used if not NULL}

\item{onlyTitles}{Read only spectrum titles, but no data. Defaults to FALSE}

\item{useAsNames}{How should sample names be generated}

\item{checkFiles}{Only check if the folder exists or contains NMR data. Defaults to FALSE}
}
\value{
An (invisible) list containing spectral data and the spectrum name
}
\description{
This function reads Bruker NMR data. 1D and 2D data are supported.
}
\examples{
exampleData<-readBruker(folder=system.file("extdata/1/10/pdata/10",package="mrbin"),
                        dimension="1D")
}
