% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens_plot.R
\name{sens_plot}
\alias{sens_plot}
\alias{sens_plot.sens_each}
\alias{sens_plot.sens_grid}
\title{Plot sensitivity analysis results}
\usage{
sens_plot(data, ...)

\method{sens_plot}{sens_each}(
  data,
  dv_name,
  logy = FALSE,
  ncol = NULL,
  lwd = 0.8,
  digits = 3,
  plot_ref = TRUE,
  xlab = "time",
  ylab = dv_name[1],
  grid = FALSE,
  ...
)

\method{sens_plot}{sens_grid}(
  data,
  dv_name,
  digits = 2,
  ncol = NULL,
  lwd = 0.8,
  logy = FALSE,
  plot_ref = TRUE,
  ...
)
}
\arguments{
\item{data}{output from \code{\link[=sens_each]{sens_each()}} or
\code{\link[=sens_grid]{sens_grid()}}}

\item{...}{arguments passed on to methods}

\item{dv_name}{output column name to plot}

\item{logy}{if \code{TRUE}, y-axis is transformed to log scale}

\item{ncol}{passed to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}}

\item{lwd}{passed to \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}}

\item{digits}{used to format numbers on the strips}

\item{plot_ref}{if \code{TRUE}, then the reference case will be plotted in a black
dashed line}

\item{xlab}{x-axis title}

\item{ylab}{y-axis title}

\item{grid}{if \code{TRUE}, plots from the \code{sens_each} method
will be passed through \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}}
}
\description{
Plot sensitivity analysis results
}
\examples{
mod <- mrgsolve::house()
dose <- mrgsolve::ev(amt = 100)
out <- sens_run(mod, sargs = list(events = dose),  par = "CL,VC") 
sens_plot(out, dv_name = "CP")

}
