% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_settings.R
\name{chart_settings}
\alias{chart_settings}
\alias{chart_settings.ms_barchart}
\alias{chart_settings.ms_linechart}
\alias{chart_settings.ms_areachart}
\alias{chart_settings.ms_scatterchart}
\title{set chart options}
\usage{
chart_settings(x, ...)

\method{chart_settings}{ms_barchart}(x, vary_colors, gap_width, dir,
  grouping, overlap, ...)

\method{chart_settings}{ms_linechart}(x, vary_colors, ...)

\method{chart_settings}{ms_areachart}(x, vary_colors = FALSE,
  grouping = "standard", ...)

\method{chart_settings}{ms_scatterchart}(x, vary_colors = FALSE,
  scatterstyle = "lineMarker", ...)
}
\arguments{
\item{x}{an \code{ms_chart} object.}

\item{...}{unused parameter}

\item{vary_colors}{if \code{TRUE} the data points in the single series are displayed the same color.}

\item{gap_width}{A gap appears between the bar or clustered bars for each category on a bar chart.
The default width for this gap is 150 percent of the bar width. It can be set
between 0 and 500 percent of the bar width.}

\item{dir}{the direction of the bars in the chart, value must one of "horizontal" or "vertical".}

\item{grouping}{grouping for a barchart, a linechart or an area chart. must be one of "percentStacked", "clustered", "standard" or "stacked".}

\item{overlap}{In a bar chart having two or more series, the bars for each
category are clustered together. By default, these bars are directly
adjacent to each other. The bars can be made to overlap each other or
have a space between them using the overlap property. Its values range
between -100 and 100, representing the percentage of the bar width by
which to overlap adjacent bars. A setting of -100 creates a gap of a
full bar width and a setting of 100 causes all the bars in a category
to be superimposed. The default value is 0.}

\item{scatterstyle}{The Style for the scatter chart. One
of 'none', 'line', 'lineMarker', 'marker', 'smooth', 'smoothMarker'.}
}
\description{
Set chart properties.
}
\section{Methods (by class)}{
\itemize{
\item \code{ms_barchart}: barchart settings

\item \code{ms_linechart}: linechart settings

\item \code{ms_areachart}: linechart settings

\item \code{ms_scatterchart}: linechart settings
}}

