% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{packMsg}
\alias{packMsg}
\alias{packMsgs}
\alias{packOpts}
\alias{prepack}
\alias{prepack.default}
\alias{prepack.data.frame}
\title{Convert R objects to msgpack format.}
\usage{
packMsg(x, ...)

packMsgs(xs, ...)

packOpts(compatible = FALSE, as_is = FALSE, use_dict = TRUE,
  max_size = NA, buf_size = 512)

prepack(x)

\method{prepack}{default}(x)

\method{prepack}{data.frame}(x)
}
\arguments{
\item{x}{An R object, which can be null, a vector, list,
environment, raw, or any combinations thereof.}

\item{...}{Options passed to \code{\link[=packOpts]{packOpts()}}}

\item{xs}{a list of objects to pack.}

\item{compatible}{If TRUE, emitted bytes conform to version 1.0 of
msgpack encoding. This means that msgpack strings are used for
raw objects.}

\item{as_is}{If TRUE, singletons (R primitive vectors of length 1
having no names attribute) are encoded as msgpack arrays of
length 1. Otherwise singletons are simplified to msgpack scalars.}

\item{use_dict}{If TRUE, vectors having a "names" attribute are
encoded as dicts. If false, they are encoded as arrays and the
names are discarded.}

\item{max_size}{The largest buffer that will be allocated.}

\item{buf_size}{The initial amount of memory, in bytes, to allocate
for packing each message. This will be dynamically grown if a
larger message is passed, so there is little reason to change
this.}
}
\value{
An object of class "raw".
}
\description{
Convert R objects to msgpack format.

\code{\link[=packOpts]{packOpts()}} interprets the \code{...} argument of packMsg and
packMsgs. it is not exported.
}
\details{
Strings are re-encoded to UTF-8 if necessary. Real numbers
taking integral values may be emitted as integers to save space.

Normally an R vector of length 1 will be unboxed, e.g. packMsg(1)
will make a msgpack integer, but packMsg(c(1,2)) will make a
msgpack list. To prevent this and produce a list of length 1 in the
first case, specify \code{as_is = TRUE}. Objects of class \code{AsIs} or
\code{data.frame} will always be encoded as-is.

A hook for pre-processing R objects before packing is supported, by
giving the object an S3 \link{class} and implementing a method
\code{prepack}. For instance, \code{prepack.data.frame(x)} simply adds the
\code{"AsIs"} class to \code{x}.

Environment objects are written out with the keys in sorted order,
but named vectors are written in the order which the entries
appear.

Object attributes other than \code{names} and \code{class} are ignored.
}
\examples{
packMsg( list(compact=TRUE, schema=0) )
x <- packMsgs(list("one", "two", "three"))
unpackMsgs(x, 2)
}
