% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourmtd.R
\name{contourmtd}
\alias{contourmtd}
\title{Contour Plot of the Bivariate \eqn{t} Density}
\usage{
contourmtd(nu, mu, Sigma,
                   xlim = c(mu[1] + c(-10, 10)*Sigma[1, 1]),
                   ylim = c(mu[2] + c(-10, 10)*Sigma[2, 2]),
                   zlim = NULL, npt = 30, nx = npt, ny = npt,
                   main = "Multivariate t density",
                   sub = NULL, nlevels = 10,
                   levels = pretty(zlim, nlevels), tol = 1e-6, ...)
}
\arguments{
\item{nu}{numeric. The degrees of freedom.}

\item{mu}{length 2 numeric vector.}

\item{Sigma}{symmetric, positive-definite square matrix of order 2. The scatter matrix.}

\item{xlim, ylim}{x-and y- limits.}

\item{zlim}{z- limits. If NULL, it is the range of the values of the density on the x and y values within \code{xlim} and \code{ylim}.}

\item{npt}{number of points for the discretisation.}

\item{nx, ny}{number of points for the discretisation among the x- and y- axes.}

\item{main, sub}{main and sub title, as for \code{\link{title}}.}

\item{nlevels, levels}{arguments to be passed to the \code{\link{contour}} function.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in Sigma, for the estimation of the density. see \code{\link{dmtd}}.}

\item{...}{additional arguments to \code{\link{plot.window}}, \code{\link{title}}, \code{\link{Axis}} and \code{\link{box}}, typically \link{graphical parameters} such as \code{cex.axis}.}
}
\value{
Returns invisibly the probability density function.
}
\description{
Draws the contour plot of the probability density of the multivariate \eqn{t} distribution with 2 variables
with location parameter \code{mu} and scatter matrix \code{Sigma}.
}
\examples{
nu <- 1
mu <- c(1, 4)
Sigma <- matrix(c(0.8, 0.2, 0.2, 0.2), nrow = 2)
contourmtd(nu, mu, Sigma)

}
\references{
S. Kotz and Saralees Nadarajah (2004), Multivariate \eqn{t} Distributions and Their Applications, Cambridge University Press.
}
\seealso{
\code{\link{dmtd}}: probability density of a multivariate \eqn{t} density

\code{\link{plotmtd}}: 3D plot of a bivariate \eqn{t} density.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
