\name{nomLORgee}
\alias{nomLORgee}
\title{
Marginal Models For Correlated Nominal Multinomial Responses
}
\description{
Solving the generalized estimating equations for correlated nominal multinomial responses assuming a baseline category logit model for the marginal probabilities.
}
\usage{
nomLORgee(formula, data, id = id, repeated = NULL, 
          bstart = NULL, LORstr = "time.exch", LORem = "3way", LORterm = NULL, 
          add = 0, homogeneous = TRUE, control = LORgee.control(), 
          ipfp.ctrl = ipfp.control(), IM = "solve")
}
\arguments{
  \item{formula}{
a formula expression as for other regression models for multinomial responses. An intercept term must be included.
}
 \item{data}{
an optional data frame containing the variables provided in \code{formula}, \code{id} and \code{repeated}. 
}
  \item{id}{
a vector that identifies the clusters.
}
  \item{repeated}{
an optional vector that identifies the order of the observations within each cluster.
}
  \item{bstart}{
a vector that includes an initial estimate for the marginal regression parameter vector.
}
 \item{LORstr}{
a character string that indicates the marginalized local odds ratios structure. Options include \code{"independence"}, \code{"time.exch"}, \code{"RC"} or \code{"fixed"}.
}
  \item{LORem}{
a character string that indicates if the marginalized local odds ratios structure is estimated simultaneously (\code{"3way"}) or independently at each level pair of \code{repeated} (\code{"2way"}).
}
  \item{LORterm}{
a matrix that satisfies the user-defined local odds ratios structure. It is ignored unless \code{LORstr="fixed"}.
}
  \item{add}{
a positive constant to be added at each cell of the full marginalized contingency table in the presence of zero observed counts.
}
  \item{homogeneous}{
a logical that indicates homogeneous score parameters when \code{LORstr="time.exch"} or \code{"RC"}.
}
  \item{control}{
a vector that specifies the control variables for the GEE solver.
}
  \item{ipfp.ctrl}{
a vector that specifies the control variables for the function \code{ipfp}.
}
  \item{IM}{
a character string that indicates the method used for inverting a matrix. Options include \code{"solve"}, \code{"qr.solve"} or \code{"cholesky"}.
}
}
\details{
The \code{data} must be provided in case level or equivalently in `long' format. See details about the `long' format in the function \link{reshape}.

A term of the form \code{offset(expression)} is allowed in the right hand side of \code{formula}.

The default set for the response categories is \eqn{\{1,\ldots,J\}}, where \eqn{J>2} is the maximum observed response category. If otherwise, the function recodes the observed response categories onto this set. 

The \eqn{J}-th response category is treated as baseline.

The default set for the \code{id} labels is \eqn{\{1,\ldots,N\}}, where \eqn{N} is the sample size. If otherwise, the function recodes the given labels onto this set. 

The argument \code{repeated} can be ignored only when \code{data} is written in such a way that the \eqn{t}-th observation in each cluster is recorded at the \eqn{t}-th measurement occasion. If this is not the case, then the user must provide \code{repeated}. The suggested set for the levels of \code{repeated} is \eqn{\{1,\ldots,T\}}, where \eqn{T} is the number of observed levels. If otherwise, the function recodes the given levels onto this set. 

The variables \code{id} and \code{repeated} do not need to be pre-sorted. Instead the function reshapes \code{data} in an ascending order of \code{id} and \code{repeated}.
 
The fitted marginal baseline category logit model is 
\deqn{log \frac{Pr(Y_{it}=j |x_{it})}{Pr(Y_{it}=J |x_{it})}=\beta_{j0} +\beta^{'}_j x_{it}}
where \eqn{Y_{it}} is the \eqn{t}-th multinomial response for cluster \eqn{i}, \eqn{x_{it}} is the associated covariates vector, \eqn{\beta_{j0}} is the \eqn{j}-th response category specific intercept and \eqn{\beta_{j}} is the \eqn{j}-th response category specific parameter vector.

The formula is easier to read from either the Vignette or the Reference Manual (both available \href{https://CRAN.R-project.org/package=multgee}{here}).

The \code{LORterm} argument must be an \eqn{L} x \eqn{J^2} matrix, where \eqn{L} is the number of level pairs of \code{repeated}. These are ordered as \eqn{(1,2), (1,3), ...,(1,T), (2,3),...,(T-1,T)} and the rows of \code{LORterm} are supposed to preserve this order. Each row is assumed to contain the vectorized form of a probability table that satisfies the desired local odds ratios structure.
}
\value{
Returns an object of the class \code{"LORgee"}. This has components:
\item{call}{the matched call.}
\item{title}{title for the GEE model.}
\item{version}{the current version of the GEE solver.}
\item{link}{the marginal link function.}
\item{local.odds.ratios}{the marginalized local odds ratios structure variables.}
\item{terms}{the \code{terms} structure describing the marginal model.}
\item{contrasts}{the \code{contrasts} used for the factors.}
\item{nobs}{the number of observations.}
\item{convergence}{the values of the convergence variables.}
\item{coefficients}{the estimated regression parameter vector of the marginal model.}
\item{linear.pred}{the estimated linear predictor of the marginal regression model. The \eqn{j}-th column corresponds to the \eqn{j}-th response category.}
\item{fitted.values}{the estimated fitted values of the marginal regression model. The \eqn{j}-th column corresponds to the \eqn{j}-th response category.}
\item{residuals}{the residuals of the marginal regression model based on the binary responses. The \eqn{j}-th column corresponds to the \eqn{j}-th response category.}
\item{y}{the multinomial response variables.}
\item{id}{the \code{id} variable.}
\item{max.id}{the number of clusters.}
\item{clusz}{the number of observations within each cluster.}
\item{robust.variance}{the estimated "robust" covariance matrix.}
\item{naive.variance}{the estimated "naive" or "model-based" covariance matrix.}
\item{xnames}{the regression coefficients' symbolic names.}
\item{categories}{the number of observed response categories.}
\item{occasions}{the levels of the \code{repeated} variable.}
\item{LORgee.control}{the control values for the GEE solver.}
\item{ipfp.control}{the control values for the function \code{ipfp}.}
\item{inverse.method}{the method used for inverting matrices.}
\item{adding.constant}{the value used for \code{add}.}
\item{pvalue}{the p-value based on a Wald test that no covariates are statistically significant.}
Generic \link{coef}, \link{summary}, \link{print}, \link{fitted} and \link{residuals} methods are available. The \code{pvalue of the Null model} corresponds to the hypothesis \eqn{H_0: \beta_1=...=\beta_{J-1}=0} based on the Wald test statistic. 
}
\references{
Touloumis, A. (2011) \emph{GEE for multinomial responses}. PhD dissertation, University of Florida.

Touloumis, A., Agresti, A. and Kateri, M. (2013) GEE for multinomial responses using a local odds ratios parameterization. \emph{Biometrics}, \bold{69}, 633-640.

Touloumis, A. (2015) R Package multgee: A Generalized Estimating Equations Solver for Multinomial Responses. \emph{Journal of Statistical Software}, \bold{64}, 1-14.
}
\author{
Anestis Touloumis
}
\seealso{
For an ordinal response scale use the function \link{ordLORgee}. 
}
\examples{
## See the interpretation in Touloumis (2011).
data(housing)
fitmod <- nomLORgee(y~factor(time)*sec,data=housing,id=id, repeated=time)
summary(fitmod) 
}