% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{multibias_meta}
\alias{multibias_meta}
\title{Correction for meta-analysis with multiple biases}
\usage{
multibias_meta(
  yi,
  vi,
  sei,
  cluster = 1:length(yi),
  biased = TRUE,
  selection_ratio,
  bias_affirmative,
  bias_nonaffirmative,
  favor_positive = TRUE,
  alpha_select = 0.05,
  ci_level = 0.95,
  small = TRUE,
  return_worst_meta = FALSE,
  return_pubbias_meta = FALSE
)
}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed.}

\item{vi}{A vector of estimated variances (i.e., squared standard errors) for
the point estimates.}

\item{sei}{A vector of estimated standard errors for the point estimates.
(Only one of \code{vi} or \code{sei} needs to be specified).}

\item{cluster}{Vector of the same length as the number of rows in the data,
indicating which cluster each study should be considered part of (defaults
to treating studies as independent; i.e., each study is in its own cluster).}

\item{biased}{Boolean indicating whether each study is considered internally
biased; either single value used for all studies or a vector the same
length as the number of rows in the data (defaults to all studies).}

\item{selection_ratio}{Ratio by which publication bias favors affirmative
studies (i.e., studies with p-values less than \code{alpha_select} and
estimates in the direction indicated by \code{favor_positive}).}

\item{bias_affirmative}{Mean internal bias, on the additive scale, among
published affirmative studies. The bias has the same units as \code{yi}.}

\item{bias_nonaffirmative}{Mean internal bias, on the additive scale, among
published nonaffirmative studies. The bias has the same units as \code{yi}.}

\item{favor_positive}{\code{TRUE} if publication bias are
assumed to favor significant positive estimates; \code{FALSE} if assumed to
favor significant negative estimates.}

\item{alpha_select}{Alpha level at which an estimate's probability of being
favored by publication bias is assumed to change (i.e.,
the threshold at which study investigators, journal editors, etc., consider
an estimate to be significant).}

\item{ci_level}{Confidence interval level (as proportion) for the corrected
point estimate. (The alpha level for inference on the corrected point
estimate will be calculated from \code{ci_level}.)}

\item{small}{Should inference allow for a small meta-analysis? We recommend
always using \code{TRUE}.}

\item{return_worst_meta}{Boolean indicating whether the worst-case
meta-analysis of only the nonaffirmative studies be returned.}

\item{return_pubbias_meta}{Boolean indicating whether a meta-analysis
correcting for publication but not for confounding be returned.}
}
\value{
An object of class \code{\link[metabias:metabias-class]{metabias::metabias()}}, a list containing:
\describe{
\item{data}{A tibble with one row per study and the columns
\code{yi}, \code{vi}, \code{sei}, \code{biased}, \code{cluster}, \code{affirmative}, \code{yi_adj}, \code{weight}, \code{userweight}.}
\item{values}{A list with the elements \code{selection_ratio}, \code{bias_affirmative}, \code{bias_nonaffirmative}, \code{favor_positive}, \code{alpha_select}, \code{ci_level}, \code{small}.}
\item{stats}{A tibble with the columns \code{model}, \code{estimate}, \code{se}, \code{ci_lower}, \code{ci_upper}, \code{p_value}.}
\item{fit}{A list of fitted models.}
}
}
\description{
Correction for meta-analysis with multiple biases
}
\examples{
# publication bias without internal bias
meta_0 <- multibias_meta(yi = meta_meat$yi,
                         vi = meta_meat$vi,
                         selection_ratio = 4,
                         bias_affirmative = 0,
                         bias_nonaffirmative = 0)
meta_0$stats

# publication bias and internal bias in the non-randomized studies
meta_4 <- multibias_meta(yi = meta_meat$yi,
                         vi = meta_meat$vi,
                         biased = !meta_meat$randomized,
                         selection_ratio = 4,
                         bias_affirmative = log(1.5),
                         bias_nonaffirmative = log(1.1))
meta_4$stats

# treat all studies as biased, not just non-randomized ones
meta_all <- multibias_meta(yi = meta_meat$yi,
                           vi = meta_meat$vi,
                           biased = TRUE,
                           selection_ratio = 4,
                           bias_affirmative = log(1.5),
                           bias_nonaffirmative = log(1.1))
meta_all$stats
}
\references{
\insertRef{mathur2022multibias}{multibiasmeta}
}
