% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modmedmlm.R
\name{extract.boot.modmed.mlm}
\alias{extract.boot.modmed.mlm}
\title{Post-processing of bootstrap results from boot.modmed.mlm}
\usage{
extract.boot.modmed.mlm(
  boot.obj,
  type = c("indirect", "a", "b", "cprime", "covab", "indirect.diff", "a.diff", "b.diff",
    "cprime.diff"),
  ci.type = "perc",
  ci.conf = 0.95,
  modval1 = NULL,
  modval2 = NULL
)
}
\arguments{
\item{boot.obj}{Result of \code{boot} using \code{\link{boot.modmed.mlm}}}

\item{type}{Character indicating which piece of information to extract from the model
"indirect": value of the indirect effect.
"a": Current value of a path.
"b": Current value of b path.
"cprime": Current value of c path.
"covab": Random effect covariance between a and b paths, if both paths have associated random effects.
"indirect.diff": difference in indirect effect at two values of the moderator (set by \code{modval1} and \code{modval2}).
"a.diff": difference in a at two values of the moderator (set by \code{modval1} and \code{modval2}).
"b.diff": difference in b at two values of the moderator (set by \code{modval1} and \code{modval2}).
"cprime.diff": difference cprime at two values of the moderator (set by \code{modval1} and \code{modval2}).}

\item{ci.type}{Character indicating the type of confidence interval to compute.
Currently only percentile confidence intervals are supported with "perc".}

\item{ci.conf}{Numeric value indicating the confidence level for the interval.}

\item{modval1}{If enabled, other quantities such as the indirect effect, a, b, and cprime, will be computed
at this particular value of the moderator. Otherwise, value of these quantities is directly extracted from
the model output (i.e., these would represent values of the effects when the moderator = 0).}

\item{modval2}{Second value of the moderator at which to compute the indirect effect.}
}
\value{
A list with the following elements:
\itemize{
 \item{\code{CI} A vector, typically two elements, that has the lower and upper endpoints requested confidence interval
 for the quantity requested by \code{type}.}
 \item{\code{est} Point estimate for the quantity requested by \code{type}.}
}
}
\description{
Post-processing of bootstrap results from boot.modmed.mlm
}
\details{
This is a convenience function that computes point estimates and confidence intervals from multilevel mediation
  analysis models where \code{\link{boot.modmed.mlm}} was used along with the \code{boot} package, or \code{\link{bootresid.modmed.mlm}}
  was used. This function generally assumes that type="all" was used when initially fitting the model, making all necessary
  information available for computation of indirect effects, differences between effects, and so on. If type="all"
  was not used, there is no guarantee that confidence intervals for the effects of interest can be extracted.
}
\examples{
\donttest{
## Mediation for 1-1-1 model
library(boot)

data(BPG06dat)

set.seed(1234)

# Note that R should be be MUCH larger than the value used here (e.g., 1000 or
# larger). A small number is chosen just so examples run relatively fast when
# tested.

# bootstrap all fixed and random effects
boot.result<-boot(BPG06dat, statistic=boot.modmed.mlm, R=5,
   L2ID = "id", X = "x", Y = "y", M = "m",
   random.a=TRUE, random.b=TRUE, random.cprime=TRUE,
   type="all",
   control=list(opt="nlm"))

# Point estimate and 95\% CI for indirect effect
extract.boot.modmed.mlm(boot.result, type="indirect", ci.conf=.95)

}
}
