% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modmedmlm.R
\name{extract.modmed.mlm}
\alias{extract.modmed.mlm}
\title{Post-processing of a model fit with modmed.mlm}
\usage{
extract.modmed.mlm(
  fit,
  type = c("all", "fixef", "recov", "recov.vec", "indirect", "a", "b", "cprime", "covab",
    "indirect.diff", "a.diff", "b.diff", "cprime.diff"),
  modval1 = NULL,
  modval2 = NULL
)
}
\arguments{
\item{fit}{Result of \code{\link{modmed.mlm}}.}

\item{type}{Character indicating which piece of information to extract from the model
"all": fixed effects and var-cov matrix of random effects, as a single vector.
"fixef": just fixed effects.
"recov": var-cov matrix of random effects, as a matrix.
"recov.vec": var-cov matrix of random effects, as a stacked vector.
"indirect": value of the indirect effect.
"a": Current value of a path.
"b": Current value of b path.
"cprime": Current value of c path.
"covab": Random effect covariance between a and b paths, if both paths have associated random effects.
"indirect.diff": difference in indirect effect at two values of the moderator (set by \code{modval1} and \code{modval2}).
"a.diff": difference in a at two values of the moderator (set by \code{modval1} and \code{modval2}).
"b.diff": difference in b at two values of the moderator (set by \code{modval1} and \code{modval2}).
"cprime.diff": difference cprime at two values of the moderator (set by \code{modval1} and \code{modval2}).}

\item{modval1}{If enabled, other quantities such as the indirect effect, a, b, and cprime, will be computed
at this particular value of the moderator. Otherwise, value of these quantities is directly extracted from
the model output (i.e., these would represent values of the effects when the moderator = 0).}

\item{modval2}{Second value of the moderator at which to compute the indirect effect.}
}
\value{
A vector or single numeric value corresponding to the parameter estimate(s) of interest is returned.
}
\description{
Post-processing of a model fit with modmed.mlm
}
\details{
This function extracts relevant parameter estimates from models estimated using \code{\link{modmed.mlm}}.
  For any of the .diff values, these are always the value of the effect at modval1 minus modval2.
}
\examples{
\donttest{
# Example data for 1-1-1 w/o moderation
data(BPG06dat)

# Fit model
fit<-modmed.mlm(BPG06dat,"id", "x", "y", "m",
  random.a=TRUE, random.b=TRUE, random.cprime=TRUE)
extract.modmed.mlm(fit, type="indirect")
}

}
