% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_Ab_V.R
\name{Ab_drop_fixed}
\alias{Ab_drop_fixed}
\title{Drop fixed columns in the Ab-Representation}
\usage{
Ab_drop_fixed(A, b, options)
}
\arguments{
\item{A}{a matrix defining the convex polytope via \code{A*x <= b}.
The columns of \code{A} do not include the last choice option per item type and
thus the number of columns must be equal to \code{sum(options-1)}
(e.g., the column order of \code{A} for \code{k = c(a1,a2,a2, b1,b2)}
is \code{c(a1,a2, b1)}).}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{options}{number of observable categories/probabilities for each item
type/multinomial distribution, e.g., \code{c(3,2)} for a ternary and binary item.}
}
\description{
Often inequalities refer to all probability parameters of a multinomial distribution.
This function allows to transform the inequalities into the appropriate format
\code{A * x <b} with respect to the free parameters only.
}
\examples{
# p1 < p2 < p3 < p4
A4 <- matrix(c(1, -1,  0,  0,
               0,  1, -1,  0,
               0,  0,  1, -1),
             nrow = 3, byrow = TRUE)
b4 <- c(0, 0, 0)

# drop the fixed column for: p4 = (1-p1-p2-p3)
Ab_drop_fixed(A4, b4, options = c(4))

}
