% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohort.R
\name{cohort_simulation}
\alias{cohort_simulation}
\title{Runs a cohort discrete event simulation}
\usage{
cohort_simulation(models, newdata, trans_mat, start_time = 0,
  start_state = 1, time_limit = NULL, tcovs = NULL, M = 1000,
  ci = FALSE, ci_margin = 0.95, agelimit = FALSE, agecol = "age",
  agescale = 365.25)
}
\arguments{
\item{models}{List of \code{flexsurvreg} objects.}

\item{newdata}{Data frame with covariates of individual to simulate times for. Must contain all fields
required by models.}

\item{trans_mat}{Transition matrix, such as that used in \code{mstate}.}

\item{start_time}{Entry times of individuals specified in \code{newdata}.
Can either be a single time that everyone enters at, or have as many values
 as rows in \code{newdata}. Defaults to everyone starting at time 0.}

\item{start_state}{The starting state of the individuals specified in \code{newdata}.
States can be represented by an integer (the row/column number of the state in \code{trans_mat}),
or as a string giving the name of the state in \code{trans_mat}.
Can either be a single value when everyone starts in the same state, or have as many values
 as rows in \code{newdata}. Defaults to everyone starting in state 1.}

\item{time_limit}{The maximum time to run the simulation for. If not provided then
the simulation runs until all the individuals have obtained a sink state.}

\item{tcovs}{As in \code{flexsurv::pmatrix.simfs}, this is the names of covariates that need to be
incremented by the simulation clock at each transition, such as age when modelled as age at state entry.}

\item{M}{Number of times to run the simulations in order to obtain confidence interval estimates.}

\item{ci}{Whether to calculate confidence intervals. See \code{flexsurv::pmatrix.simfs} for details.}

\item{ci_margin}{Confidence interval range to use if \code{ci} is set to \code{TRUE}.}

\item{agelimit}{Whether to automatically assign people to an 'early death' state.
This is useful as otherwise individuals can be assigned unrealistic time-to-events due to the
nature of sampling times from a random number distribution.
If this value is \code{FALSE} then no limit is applied, otherwise provide the time-limit
to be used. This limit must be in the same time-scale as the time-to-event models.}

\item{agecol}{The name of the column in \code{newdata} that holds an individual's age.}

\item{agescale}{Any multiplication to be applied to the age covariate to put it onto the same
time-scale as the simulation. This is often useful as time-to-event may be measured on a day-based
time-scale while age is typically measured in years.}
}
\value{
A data frame with state entry times for each individual.
}
\description{
Runs a cohort discrete event simulation
}
\examples{
library(multistateutils)
library(mstate)
library(flexsurv)

# Convert data to long
data(ebmt3)
tmat <- trans.illdeath()
long <- msprep(time=c(NA, 'prtime', 'rfstime'),
               status=c(NA, 'prstat', 'rfsstat'),
               data=ebmt3,
               trans=tmat,
               keep=c('age', 'dissub'))

# Fit parametric models
models <- lapply(1:3, function(i) {
    flexsurvreg(Surv(time, status) ~ age + dissub, data=long, dist='weibull')
})

sim <- cohort_simulation(models, ebmt3, tmat)
}
