% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{countMutTypes}
\alias{countMutTypes}
\title{Count Mutation Types.}
\usage{
countMutTypes(mutTable, mutType_colName = "mutType",
  sample_colName = NULL)
}
\arguments{
\item{mutTable}{data.frame including mutation types and an optional sample ID column}

\item{mutType_colName}{string, name of the column storing mutTypes}

\item{sample_colName}{string, name of the column storing sample identifiers. Can be NULL}
}
\value{
a mutationCounts-class object
}
\description{
Analyze a table (data.frame) including mutation counts. Count and aggregate Count Mutation Types. 
If multiple samples are included in the same table, results are aggregated by samples.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
x <- mutSignatures:::getTestRunArgs("countMutTypes")
x
y <- mutSignatures::countMutTypes(mutTable = x, 
                                  mutType_colName = "mutation", 
                                  sample_colName = "sample")
y


}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
