% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{deconvoluteMutCounts}
\alias{deconvoluteMutCounts}
\title{Deconvolute Mutation Counts.}
\usage{
deconvoluteMutCounts(input_mutCounts, params)
}
\arguments{
\item{input_mutCounts}{numeric matrix of Mutation Type Counts}

\item{params}{list including all parameters required for running the analysis}
}
\value{
list including all the results from the deconvolution analysis. 
This function is called within thedecipherMutationalProcesses() function 
after parameters and input data have been validated
}
\description{
Characterize mutational signatures from cancer-derived somatic mutational catalogs.
}
\details{
This is one of the core functions included in the original mutSignatures R library, 
and in the WTSI MATLAB framework. This is an internal function.
}
\examples{
 
x <- mutSignatures:::getTestRunArgs("deconvoluteMutCounts")
y <- mutSignatures:::deconvoluteMutCounts(input_mutCounts = as.matrix(x$muts),
                                          params = as.list(x$params))
y$processes[1:10,]


}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
