/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.gui.datawizard;

import af.statguitoolkit.gui.datawizard.DataWizard;
import af.statguitoolkit.gui.datawizard.LoadPanel;
import af.statguitoolkit.io.datasets.FileDescriptor;
import af.statguitoolkit.io.datasets.FileDescriptorCSV;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.af.commons.Localizer;
import org.af.commons.widgets.WidgetFactory;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPanelNavResult;

public class LoadCSVPanel
extends LoadPanel {
    private JCheckBox chbWhiteSpace;
    private JTextField tfFieldSep;
    DataWizard dataWizard;

    public static String getDescription() {
        return Localizer.getInstance().getString("SGTK_DATAWIZARD_PANEL_CSV_DESC");
    }

    public LoadCSVPanel(DataWizard dataWizard) {
        this.dataWizard = dataWizard;
        this.makeComponents();
        this.doTheLayout();
    }

    @Override
    protected void makeComponents() {
        super.makeComponents();
        this.chbWhiteSpace = new JCheckBox("", false);
        this.chbWhiteSpace.setMargin(new Insets(0, 0, 0, 0));
        this.chbWhiteSpace.setBorder(null);
        this.tfFieldSep = new JTextField(";", 1);
        WidgetFactory.registerDisabler((JCheckBox)this.chbWhiteSpace, (Component)this.tfFieldSep);
    }

    @Override
    protected void doTheLayout() {
        String cols = "pref, 5dlu, pref:grow, 5dlu, left:pref, 5dlu, left:pref, 5dlu, left:pref";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref:grow";
        FormLayout layout = new FormLayout(cols, rows);
        this.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        Localizer loc = Localizer.getInstance();
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_FILE")), cc.xy(1, 1));
        this.add(this.tfFile, cc.xyw(3, 1, 3));
        this.add(this.bSelect, cc.xyw(7, 1, 3));
        JScrollPane sp = new JScrollPane(this.taPreview);
        sp.setBorder(new TitledBorder(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_PREVIEW")));
        this.add(sp, cc.xywh(1, 3, 3, 13));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_HEADER")), cc.xy(5, 5));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_FIELDSEP")), cc.xy(5, 7));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_MISSING")), cc.xy(5, 11));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_DECPOINT")), cc.xy(5, 13));
        this.add(this.chbHeader, cc.xy(7, 5));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_WHITESPACE")), cc.xy(7, 7));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_OTHER")), cc.xy(7, 9));
        this.add(this.tfNA, cc.xy(7, 11));
        this.add(this.tfDec, cc.xy(7, 13));
        this.add(this.chbWhiteSpace, cc.xy(9, 7));
        this.add(this.tfFieldSep, cc.xy(9, 9));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bSelect) {
            this.selectFile();
        }
    }

    private void selectFile() {
        super.selectFile(new String[]{"txt", "csv"});
    }

    @Override
    protected List<String> getPreview(File file) {
        return this.readLines(file, 20);
    }

    public WizardPanelNavResult allowFinish(String stepName, Map settings, Wizard wizard) {
        if (this.tfFile.getText().trim().equals("")) {
            JOptionPane.showMessageDialog((Component)((Object)this), Localizer.getInstance().getString("SGTK_DATAWIZARD_PANEL_CSV_PLSSELECTFILE"));
            return WizardPanelNavResult.REMAIN_ON_PAGE;
        }
        this.dataWizard.dataFrameDescriptor = this.getFileDescriptor();
        return WizardPanelNavResult.PROCEED;
    }

    public FileDescriptor getFileDescriptor() {
        if (this.tfFile.getText().trim().equals("")) {
            return null;
        }
        String path = this.tfFile.getText();
        boolean h = this.chbHeader.isSelected();
        String na = this.tfNA.getText();
        Character dec = Character.valueOf(this.tfDec.getText().trim().charAt(0));
        String sep = "";
        if (!this.chbWhiteSpace.isSelected()) {
            sep = this.tfFieldSep.getText();
        }
        return new FileDescriptorCSV(path, h, na, dec, sep);
    }
}

