/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.widgets;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.validator.routines.DoubleValidator;

public class MarginTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<String> vars;
    private String[] header;
    private Hashtable<String, Double>[] toMarginValue;
    private double[] lowerLimits;
    private double[] upperLimits;
    private double[] defaults;

    public MarginTableModel(String[] header, List<String> vars) {
        this.header = header;
        this.vars = vars;
        this.toMarginValue = new Hashtable[header.length - 1];
        for (int i = 0; i < header.length - 1; ++i) {
            this.toMarginValue[i] = new Hashtable();
            for (String s : vars) {
                this.toMarginValue[i].put(s, 0.0);
            }
        }
    }

    protected static double[] getLimitArray(int n, double val) {
        double[] d = new double[n];
        Arrays.fill(d, val);
        return d;
    }

    @Override
    public int getColumnCount() {
        return this.header.length;
    }

    @Override
    public int getRowCount() {
        return this.vars.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String s = this.vars.get(rowIndex);
        if (columnIndex == 0) {
            return s;
        }
        return this.toMarginValue[columnIndex - 1].get(s);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value != null && value instanceof Number) {
            DoubleValidator validator;
            Double d;
            String s = this.vars.get(row);
            if (col > 0 && (d = (validator = new DoubleValidator()).validate(value.toString())) != null && d > this.lowerLimits[col - 1] && d < this.upperLimits[col - 1]) {
                this.toMarginValue[col - 1].put(s, d);
                this.fireTableCellUpdated(row, col);
            }
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.header[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    public void setLimits(double[] lowerLimits, double[] upperLimits, double[] defaults) {
        this.lowerLimits = lowerLimits;
        this.upperLimits = upperLimits;
        this.defaults = defaults;
        for (int i = 0; i < this.header.length - 1; ++i) {
            for (String s : this.vars) {
                this.toMarginValue[i].put(s, defaults[i]);
            }
        }
    }
}

