% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotateScaleMatrix.R
\name{rotateScale3D}
\alias{rotateScale3D}
\title{Three-Dimensional Rotation and Scaling Matrix}
\usage{
rotateScale3D(rot_angles = c(0, 0, 0), scale_factors = c(1, 1, 1))
}
\arguments{
\item{rot_angles}{a list or vector containing the rotation angles in the
order following: yaw, pitch, roll. Defaults to <0,0,0>.}

\item{scale_factors}{a list or vector containing the values by which to
multiply each dimension. Defaults to <1,1,1>.}
}
\value{
A 3 x 3 projection matrix corresponding to the degree and scale
  changes entered.
}
\description{
Render a 3-Dimensional projection matrix given positive or
  negative degree changes in yaw, pitch, and / or roll and increment or
  decrement feature scales.
}
\details{
See the help file of function rotate_3D() for a brief explanation of
  how these angles behave in scatterplot3d functionality (from package
  scatterplot3d).

  This function is used only in data generation in the package vignette
  (version 1) and the dataStateSwitch() function within the mspProcessData()
  function. This function calls rotate3D().
}
\examples{
rotateScale3D(rot_angles = list(yaw = -10, pitch = 0, roll = 15),
              scale_factors = c(0.2, 1, 5))

}
\seealso{
Calls: \code{\link{rotate3D}}. Called by
  \code{\link{dataStateSwitch}}.
}
