% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{mvnTest}
\alias{mvnTest}
\title{A Powerful Test for Multivariate Normality (Zhou-Shao's Test)}
\usage{
mvnTest(X, B = 1000, pct = c(0.01, 0.99))
}
\arguments{
\item{X}{an \eqn{n*p} data matrix or data frame, where \eqn{n} is number of rows (observations) and \eqn{p} is number of columns (variables) and \eqn{n>p}.}

\item{B}{number of Monte Carlo simulations for null distribution, default is 1000 (increase B to increase the precision of \emph{p}-value).}

\item{pct}{percentiles of MK to get \eqn{c_1} and \eqn{c_2} described in the reference paper, default is (0.01, 0.99).}
}
\value{
Returns a list with two objects:
\describe{
\item{\code{mv.test}}{results of the Zhou-Shao's test for multivariate normality , i.e., test statistic \eqn{T_n},
\emph{p}-value (under H0, i.e. multivariate normal, that \eqn{T_n} is at least as extreme as the observed value), and multivariate normality summary (YES, if \emph{p}-value>0.05).}
\item{\code{uv.shapiro}}{a dataframe with \eqn{p} rows detailing univariate Shapiro-Wilk tests. Columns in the dataframe contain test statistics \emph{W}, \emph{p}-value,and univariate normality summary (YES, if \emph{p}-value>0.05).}
}
}
\description{
A simple and powerful test for multivariate normality with a combination of multivariate
kurtosis (MK) and Shapiro-Wilk which was proposed by Zhou and Shao (2014). The \emph{p}-value of the test
statistic (\eqn{T_n}) is computed based on a simulated null distribution of \eqn{T_n}. Details see Zhou and Shao (2014).
}
\examples{
set.seed(12345)

## Data from gamma distribution ##
X = matrix(rgamma(50*4,shape =  2),50)
mvnTest(X, B=100)

## load the ubiquitous multivariate iris data ##
## (first 50 observations of columns 1:4) ##
iris.df = iris[1:50, 1:4]
mvnTest(iris.df, B=100)

}
\references{
Zhou, M., & Shao, Y. (2014). A powerful test for multivariate normality. \emph{Journal of applied statistics}, 41(2), 351-363.

Shapiro, S. S., & Wilk, M. B. (1965). An analysis of variance test for normality (complete samples). \emph{Biometrika}, 52(3/4), 591-611.
}
\seealso{
\code{\link{power.mvnTest}}, \code{\link{msk}}, \code{\link{mardia}}, \code{\link{msw}}, \code{\link{faTest}}, \code{\link{mhz}}
}
