% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{marginal.predict}
\alias{marginal.predict}
\title{Marginal Predictions for Multivariate Ordinal Regression Models.}
\usage{
marginal.predict(object, type = "prob", subjectID = NULL, ...)
}
\arguments{
\item{object}{of class \code{mvord}}

\item{type}{\code{c("prob", "class", "pred","cum.prob")}}

\item{subjectID}{(optional) vector specifying for which subjectIDs the predictions\cr or fitted values should be computed.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Obtains marginal predictions/fitted measures for objects of class \code{"mvord"}.
}
\details{
The following types can be chosen in \code{marginal.predict}:
\tabular{ll}{
  \code{type} \tab description\cr
  \code{"prob"} \tab (default) fitted marginal probabilities for the observed response categories.\cr
  \code{"class"} \tab fitted marginal classes of the observed responses\cr
  \code{"pred"} \tab linear predictor \cr
  \code{"cum.prob"} \tab fitted marginal cumulative probabilities for the observed response categories\cr
  \code{"all.prob"} \tab fitted marginal probabilities for all ordered classes of each response
  }

The current implementation supports only in-sample predictions.
The rownames of the output correspond to the subjectIDs.
}
\seealso{
\link{predict.mvord}, \code{\link{get.prob}}
}
