% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_struct.R
\name{error_struct}
\alias{error_struct}
\alias{cov_general}
\alias{cor_general}
\alias{cor_ar1}
\alias{cor_equi}
\title{Error Structures in mvord}
\usage{
cov_general(formula = ~1, value = numeric(0), fixed = FALSE)

cor_general(formula = ~1, value = numeric(0), fixed = FALSE)

cor_ar1(formula = ~1, value = numeric(0), fixed = FALSE)

cor_equi(formula = ~1, value = numeric(0), fixed = FALSE)
}
\arguments{
\item{formula}{\code{\link{formula}} object}

\item{value}{specifies values of the correlation (and variance) parameters.
For \code{cor_equi()} and \code{cor_ar1()} it can be either a vector of correlations (in (-1,1)) of length one
(same correlation for all subjects) or a vector of length equal to the number of subjects.
For \code{cor_general()}, it can be either a vector of the lower triangular correlation matrix elements
(same structure for all subjects) or a matrix with number of rows equal to the number of subjects.
For \code{cov_general()}, it can be either a vector of the lower triangular covariance matrix elements (including the diagonal)
(same structure for all subjects) or a matrix with number of rows equal to the number of subjects.
Default is \code{value = numeric(0)} object.
In this case the correlation parameters are initialized with zero (and variance parameters with 1 for \code{cov_general})}

\item{fixed}{logical specifying whether the parameters of the error structure should not be optimized in the procedure, but will be \cr
fixed to the values specified in the argument \code{value}. Defaults to \code{fixed = FALSE}.}
}
\description{
Different \code{error.structures} are available in \pkg{mvord}:
\itemize{
\item general correlation structure (default) \code{cor_general(~ 1)},
\item general covariance structure \code{cov_general(~ 1)},
\item factor dependent correlation structure \code{cor_general(~ f)},
\item factor dependent covariance structure \code{cov_general(~ f)},
\item equicorrelation structure \code{cor_equi(~ 1)},
\item covariate dependent equicorrelation structure \code{cor_equi(~ S)},
\item AR(1) correlation structure \code{cor_ar1(~ 1)}, or
\item covariate dependent AR(1) correlation structure \code{cor_ar1(~ S)}.
}
For more details see vignette.
}
