% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFunctions.R
\name{boxcarBlur}
\alias{boxcarBlur}
\title{Multichannel box car blur}
\usage{
boxcarBlur(n, width)
}
\arguments{
\item{n}{An integer specifying the number of observations in each channel}

\item{width}{A numeric vector of length m where each element specifies the box car widths to blur in each channel.}
}
\value{
A n by m matrix of normalised box car blur.
}
\description{
Create blur of the box car type.
}
\details{
Creates a matrix of dimension n by m which contains a normalised (unit energy in each column) set of box car blur functions. The generated box-car functions are governed by an input vector \code{BA} which specifies the box car width. For the method to adhere to the theory described in Wishart (2014), the box car widths should be a Badly Approximable (BA) number.
}
\examples{
n <- 1024
width <- 1/sqrt(c(89,353))

# Plot the box car blur
blurMat <- boxcarBlur(n, width)
x <- (1:n)/n
matplot(x, blurMat, type = 'l', main = paste('Set of box car blur functions'))

# Plot a LIDAR signal and its multichannel box car blurred version
signal <- makeLIDAR(n)
matplot(x, signal, type = 'l', main = 'LIDAR test signal')
blurredSignal <- blurSignal(signal, blurMat)
matplot(x, blurredSignal, type = 'l', main = 'Box car blurred LIDAR test signals')
}
\seealso{
\code{\link{gammaBlur}}, \code{\link{blurSignal}}
}

