% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states.R
\name{mc_states_replace}
\alias{mc_states_replace}
\title{Replace values by states with tag}
\usage{
mc_states_replace(data, tags, replace_value = NA)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}

\item{tags}{specific tag to be replaced.}

\item{replace_value}{(default NA).}
}
\value{
myClim object in the same format as input, with replaced values
}
\description{
This function replace values of sensors by states with tag.
}
\examples{
states <- data.frame(locality_id="A1E05", logger_index=1, sensor_name="Thermo_T", tag="error",
                     start=lubridate::ymd_hm("2020-10-28 9:00"),
                     end=lubridate::ymd_hm("2020-10-28 9:30"))
data <- mc_states_insert(mc_data_example_clean, states)
data <- mc_states_replace(data, "error")
}
