% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotGroupDiffs.R
\name{PlotGroupDiffs}
\alias{PlotGroupDiffs}
\title{Plot the significant differences between gene expression distributions of PS or DS groups}
\usage{
PlotGroupDiffs(ExpressionSet, Groups = NULL, legendName = NULL,
  stat.test = "wilcox.test", col = c("turquoise3", "magenta3"),
  plot.type = NULL, gene.set = NULL, ...)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}

\item{Groups}{a list containing the phylostrata or divergence strata that correspond 
to the same phylostratum class or divergence class.
For ex. evolutionary old phylostrata: PS1-3 (Class 1) 
and evolutionary young phylostrata: PS4-12 (Class 2). In this case, 
the list could be assigned as, \code{Groups} = list(c(1:3), c(4:12)).}

\item{legendName}{a character string specifying whether "PS" or "DS" are used to compute relative expression profiles.}

\item{stat.test}{the statistical test to quantify PS or DS group differences.}

\item{col}{colors for the two box plots representing the expression level distributions of selected PS/DS groups.}

\item{plot.type}{the type of plot that shall be drawn to visualized the difference in PS/DS group specific expression .}

\item{gene.set}{a character vector storing the gene ids for which group specific differences shall be statistically quantified.}

\item{...}{additional plot parameters.}
}
\description{
This function performs a test to quantify the statistical significance between
the global expression level distributions of groups of PS or DS. It therefore, allows users to investigate
significant groups of PS or DS that significantly differ in their gene expression level distibution
within specific developmental stages or experiments.
}
\details{
The purpose of this function is to detect groups of PS or DS that significantly differ in their gene expression
level distributions on a global (transcriptome) level. Since relative expression levels (\code{\link{PlotRE}}) or
PS or DS specific mean expression levels (\code{\link{PlotMeans}}) are biased by highly expressed genes,
this function allows users to objectively test the significant difference of transcriptome expression between
groups of PS or DS in a specific developmental stage or experiment.

In particular, this function divides (for each developmental stage separately) the gene expression levels into two groups: Group1 = genes deriving from selected PS/DS in group 1 and 
Group2 = genes deriving from selected PS/DS in group 2. Within each stage the expression level distributions between group 1 and group 2 are statistically quantified using a \code{\link{wilcox.test}}.
}
\examples{

data(PhyloExpressionSetExample)

PlotGroupDiffs(ExpressionSet = PhyloExpressionSetExample,
               Groups        = list(group_1 = 1:3,group_2 = 4:12),
               legendName    = "PS",
               type          = "b",
               lwd           = 6,
               xlab          = "Ontogeny")
               
               
# only receive the p-values without the corresponding plot               
PlotGroupDiffs(ExpressionSet = PhyloExpressionSetExample,
               Groups        = list(group_1 = 1:3,group_2 = 4:12),
               legendName    = "PS",
               plot.p.vals   = FALSE,
               type          = "b",
               lwd           = 6,
               xlab          = "Ontogeny")
               
               
# quantify the significant difference of a selected set of genes
# only receive the p-values without the corresponding plot
set.seed(123)
ExampleGeneSet <- sample(PhyloExpressionSetExample[ , 2],5000)
                              
PlotGroupDiffs(ExpressionSet = PhyloExpressionSetExample,
               Groups        = list(group_1 = 1:3,group_2 = 4:12),
               legendName    = "PS",
               plot.p.vals   = FALSE,
               gene.set      = ExampleGeneSet)                 


# plot differences as boxplot for each developmental stage
PlotGroupDiffs(ExpressionSet = tf(PhyloExpressionSetExample,log2),
               Groups        = list(group_1 = 1:3,group_2 = 4:12),
               legendName    = "PS",
               plot.type     = "boxplot")


}
\seealso{
\code{\link{PlotMeans}}, \code{\link{PlotRE}}, \code{\link{PlotBarRE}}, \code{\link{PlotCategoryExpr}}, \code{\link{GroupDiffs}}
}
\author{
Hajk-Georg Drost
}
