% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distribution_expression.R
\name{plot_distribution_expression}
\alias{plot_distribution_expression}
\title{Comparing expression levels distributions across developmental stages}
\usage{
plot_distribution_expression(
  phyex_set,
  show_identities = TRUE,
  show_strata = FALSE,
  log_transform = TRUE,
  seed = 123
)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object (BulkPhyloExpressionSet or ScPhyloExpressionSet).}

\item{show_identities}{Logical, whether to show identity-specific distributions.}

\item{show_strata}{Logical, whether to show stratum-specific distributions.}

\item{log_transform}{Logical, whether to apply log transformation to expression values (default: TRUE).}

\item{seed}{Seed for reproducible color selection.}
}
\value{
A ggplot2 object showing expression levels distributions across identities
}
\description{
\code{plot_distribution_expression} generates plots that help to compare the distribution
of expression levels through various developmental stages or cell types, highlighting each stage with
distinct colors. By default, a log transformation is applied to the expression values.
}
\section{Recommendation}{
 
Apply a square root transformation to enhance the visualization of differences
in the distributions: \code{plot_distribution_expression(transform_counts(phyex_set, sqrt))}
}

\author{
Filipa Martins Costa
}
