% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naaccr_record.R
\name{as.naaccr_record}
\alias{as.naaccr_record}
\alias{as.naaccr_record.list}
\alias{as.naaccr_record.data.frame}
\title{Coerce to a naaccr_record dataset
Convert objects into \code{naaccr_record} objects, if a method exists.}
\usage{
as.naaccr_record(x, keep_unknown = FALSE, version = NULL,
  format = NULL, ...)

\method{as.naaccr_record}{list}(x, keep_unknown = FALSE,
  version = NULL, format = NULL, ...)

\method{as.naaccr_record}{data.frame}(x, keep_unknown = FALSE,
  version = NULL, format = NULL, ...)
}
\arguments{
\item{x}{An R object.}

\item{keep_unknown}{Logical indicating whether values of "unknown" should be
a level in the factor or \code{NA}.}

\item{version}{An integer specifying the NAACCR format version for parsing
the records. Use this or \code{format}, not both. If both \code{version}
and \code{format} are \code{NULL} (default), the most recent NAACCR format
will be used.}

\item{format}{A \code{\link{record_format}} object for parsing the records.}

\item{...}{Additional arguments passed to or from methods.}
}
\value{
An object of class \code{\link{naaccr_record}}
}
\description{
Coerce to a naaccr_record dataset
Convert objects into \code{naaccr_record} objects, if a method exists.
}
\seealso{
\code{\link{naaccr_record}}
}
