test_that("Correct outcome format and size for base outcome1",
            {
              outcome1 <- naive(time_features[, 2:3, drop = F], seq_len = 30, n_samp = 1, n_windows = 5)
              expect_equal(class(outcome1), "list")
              expect_equal(length(outcome1), 4)
              expect_equal(names(outcome1), c("exploration", "history", "best_model", "time_log"))
              expect_equal(names(outcome1$best_model), c("quant_preds", "plots", "errors"))
              expect_equal(class(outcome1$history), "data.frame")
              expect_equal(dim(outcome1$history), c(1, 18))
              expect_equal(length(outcome1$best_model$quant_preds), 2)
              expect_equal(class(outcome1$best_model$quant_preds), "list")
              expect_equal(all(sapply(outcome1$best_model$quant_preds, is.data.frame)), TRUE)
              expect_equal(dim(outcome1$best_model$quant_preds$IBM.Close), c(30, 17))
              expect_equal(dim(outcome1$best_model$quant_preds$AAPL.Close), c(30, 17))
              expect_equal(all(rownames(outcome1$best_model$quant_preds$IBM.Close) == paste0("t", 1:30)), TRUE)
              expect_equal(class(outcome1$best_model$errors), "data.frame")
              expect_equal(class(outcome1$best_model$plot), c("list"))
              expect_equal(class(outcome1$best_model$plot$IBM.Close), c("gg", "ggplot"))
              expect_equal(class(outcome1$best_model$plot$AAPL.Close), c("gg", "ggplot"))
              expect_equal(dim(outcome1$best_model$errors), c(2, 13))
              expect_equal(class(outcome1$time_log)[1], "Period")
            })


test_that("Correct outcome format and size for base outcome2",
          {
            outcome2 <- naive(time_features[, 3, drop = F], seq_len = 20, n_samp = 10, n_windows = 5, dates = time_features$date)
            expect_equal(class(outcome2), "list")
            expect_equal(length(outcome2), 4)
            expect_equal(names(outcome2), c("exploration", "history", "best_model", "time_log"))
            expect_equal(names(outcome2$best_model), c("quant_preds", "plots", "errors"))
            expect_equal(class(outcome2$history), "data.frame")
            expect_equal(dim(outcome2$history), c(10, 18))
            expect_equal(length(outcome2$best_model$quant_preds), 1)
            expect_equal(class(outcome2$best_model$quant_preds), "list")
            expect_equal(all(sapply(outcome2$best_model$quant_preds, is.data.frame)), TRUE)
            expect_equal(dim(outcome2$best_model$quant_preds$AAPL.Close), c(20, 17))
            expect_equal(all(rownames(outcome2$best_model$quant_preds$AAPL.Close) == paste0("t", 1:20)), FALSE)
            expect_equal(class(outcome2$best_model$errors), "data.frame")
            expect_equal(class(outcome2$best_model$plot), c("list"))
            expect_equal(class(outcome2$best_model$plot$AAPL.Close), c("gg", "ggplot"))
            expect_equal(dim(outcome2$best_model$errors), c(1, 13))
            expect_equal(class(outcome2$time_log)[1], "Period")
          })

test_that("Correct outcome format and size for base outcome3",
          {
            outcome3 <- naive(time_features[, -1, drop = F], seq_len = 60, n_samp = 15, n_windows = 5)
            expect_equal(class(outcome3), "list")
            expect_equal(length(outcome3), 4)
            expect_equal(names(outcome3), c("exploration", "history", "best_model", "time_log"))
            expect_equal(names(outcome3$best_model), c("quant_preds", "plots", "errors"))
            expect_equal(class(outcome3$history), "data.frame")
            expect_equal(dim(outcome3$history), c(15, 18))
            expect_equal(length(outcome3$best_model$quant_preds), 5)
            expect_equal(class(outcome3$best_model$quant_preds), "list")
            expect_equal(all(sapply(outcome3$best_model$quant_preds, is.data.frame)), TRUE)
            expect_equal(dim(outcome3$best_model$quant_preds$GOOGL.Close), c(60, 17))
            expect_equal(all(rownames(outcome3$best_model$quant_preds$GOOGL.Close) == paste0("t", 1:60)), TRUE)
            expect_equal(class(outcome3$best_model$errors), "data.frame")
            expect_equal(class(outcome3$best_model$plot), c("list"))
            expect_equal(class(outcome3$best_model$plot$GOOGL.Close), c("gg", "ggplot"))
            expect_equal(dim(outcome3$best_model$errors), c(5, 13))
            expect_equal(class(outcome3$time_log)[1], "Period")
          })


