% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{median_filter}
\alias{median_filter}
\alias{smooth_filter}
\title{Smooth and median filters with options for handling NAs.}
\usage{
median_filter(mat, size = 1L, na_rm = FALSE, na_count = FALSE)

smooth_filter(mat, size = 1L, na_rm = FALSE, na_count = FALSE)
}
\arguments{
\item{mat}{A matrix (representing an image).}

\item{size}{An integer; the median filter radius.}

\item{na_rm}{Should \code{NA}s be ignored?}

\item{na_count}{If this is TRUE, in each median calculation, if the majority
of arguments are \code{NA}s, \code{NA} is returned but if the \code{NA}s are
in the minority, they are ignored as in \code{median(x, na.rm = TRUE)}.}
}
\value{
A matrix (the median filtered image).
}
\description{
These are alternatives to
\code{EBImage::filter2()} and \code{EBImage::medianFilter()} for
smooth and median filtering respectively. These functions have many options
for dealing with \code{NA} values which \code{EBImage}'s functions lack.
}
\details{
The behavior at image boundaries is such as the source image has been padded
with pixels whose values equal the nearest border pixel value.
}
\examples{
m <- matrix(1:9, nrow = 3)
m[2:3, 2:3] <- NA
print(m)
median_filter(m)
median_filter(m, na_rm = TRUE)
median_filter(m, na_count = TRUE)

smooth_filter(m)
smooth_filter(m, na_rm = TRUE)
smooth_filter(m, na_count = TRUE)

}
