% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nabular.R
\name{nabular}
\alias{nabular}
\title{Convert data into nabular form by binding shade to it}
\usage{
nabular(data, only_miss = FALSE, ...)
}
\arguments{
\item{data}{a dataframe}

\item{only_miss}{logical - if FALSE (default) it will bind a dataframe with
all of the variables duplicated with their shadow. Setting this to TRUE
will bind variables only those variables that contain missing values.
See the examples for more details.}

\item{...}{extra options to pass to \code{\link[=recode_shadow]{recode_shadow()}} - a work in progress.}
}
\value{
data with the added variable shifted and the suffix \verb{_NA}
}
\description{
Binding a shadow matrix to a regular dataframe converts it into nabular data,
which makes it easier to visualise and work with missing data.
}
\examples{

aq_nab <- nabular(airquality)
aq_s <- bind_shadow(airquality)

all.equal(aq_nab, aq_s)

}
\seealso{
\code{\link[=bind_shadow]{bind_shadow()}}
}
