% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{cluster_elements}
\alias{cluster_elements}
\alias{cluster_elements,spec_tbl_df-method}
\alias{cluster_elements,tbl_df-method}
\title{Get clusters of elements (e.g., elements or features)}
\usage{
cluster_elements(
  .data,
  .element,
  .feature,
  .value,
  method,
  of_elements = TRUE,
  transform = NULL,
  action = "add",
  ...
)

\S4method{cluster_elements}{spec_tbl_df}(
  .data,
  .element,
  .feature,
  .value,
  method,
  of_elements = TRUE,
  transform = NULL,
  action = "add",
  ...
)

\S4method{cluster_elements}{tbl_df}(
  .data,
  .element,
  .feature,
  .value,
  method,
  of_elements = TRUE,
  transform = NULL,
  action = "add",
  ...
)
}
\arguments{
\item{.data}{A `tbl` formatted as | <element> | <feature> | <value> | <...> |}

\item{.element}{The name of the element column (normally elements).}

\item{.feature}{The name of the feature column (normally features)}

\item{.value}{The name of the column including the numerical value the clustering is based on (normally feature value)}

\item{method}{A character string. The cluster algorithm to use, ay the moment k-means is the only algorithm included.}

\item{of_elements}{A boolean. In case the input is a nanny object, it indicates Whether the element column will be element or feature column}

\item{transform}{A function to use to tranforma the data internalli (e.g., log1p)}

\item{action}{A character string. Whether to join the new information to the input tbl (add), or just get the non-redundant tbl with the new information (get).}

\item{...}{Further parameters passed to the function kmeans}
}
\value{
A tbl object with additional columns with cluster labels

A tbl object with additional columns with cluster labels

A tbl object with additional columns with cluster labels
}
\description{
cluster_elements() takes as imput a `tbl` formatted as | <element> | <feature> | <value> | <...> | and identify clusters in the data.
}
\details{
\lifecycle{maturing}

identifies clusters in the data, normally of elements.
This function returns a tibble with additional columns for the cluster annotation.
At the moment only k-means clustering is supported, the plan is to introduce more clustering methods.
}
\examples{


   cluster_elements(mtcars_tidy, car_model, feature, value, method="kmeans",	centers = 2)

}
