% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{keep_variable}
\alias{keep_variable}
\alias{keep_variable,spec_tbl_df-method}
\alias{keep_variable,tbl_df-method}
\title{Keep top variable features across elements}
\usage{
keep_variable(.data, .element, .feature, .value, top = Inf, transform = NULL)

\S4method{keep_variable}{spec_tbl_df}(.data, .element, .feature, .value, top = Inf, transform = NULL)

\S4method{keep_variable}{tbl_df}(.data, .element, .feature, .value, top = Inf, transform = NULL)
}
\arguments{
\item{.data}{A `tbl`}

\item{.element}{A character name of the element column}

\item{.feature}{A character name of the transcript/gene column}

\item{.value}{A character name of the read count column}

\item{top}{An integer. How many top genes to select}

\item{transform}{A function to use to tranforma the data internalli (e.g., log1p)}
}
\value{
A `tbl` with filtered features

A `tbl` with filled abundance

A `tbl` with filled abundance
}
\description{
keep_variable() takes as imput a `tbl` formatted as | <element> | <feature> | <value> | <...> | and returns a `tbl` with the filtered most variable features. The formula used is from limma::plotMDS (Robinson et al., 2010, <doi:10.1093/bioinformatics/btp616>)
}
\details{
\lifecycle{maturing}

...
}
\examples{

keep_variable(mtcars_tidy, car_model, feature, value, top=10)


}
